/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.message;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.minestom.server.entity.Player;
import net.minestom.server.message.ChatMessageType;
import net.minestom.server.message.ChatPosition;
import net.minestom.server.network.packet.server.play.SystemChatPacket;
import net.minestom.server.utils.PacketSendingUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Messenger {
    public static final Component CANNOT_SEND_MESSAGE = Component.translatable("chat.cannotSend", (TextColor)NamedTextColor.RED);
    private static final UUID NO_SENDER = new UUID(0L, 0L);
    private static final SystemChatPacket CANNOT_SEND_PACKET = new SystemChatPacket(CANNOT_SEND_MESSAGE, false);

    public static boolean sendMessage(@NotNull Player player, @NotNull Component message, @NotNull ChatPosition position, @Nullable UUID uuid) {
        if (Messenger.getChatMessageType(player).accepts(position)) {
            player.sendPacket(new SystemChatPacket(message, false));
            return true;
        }
        return false;
    }

    public static void sendMessage(@NotNull Collection<Player> players, @NotNull Component message, @NotNull ChatPosition position, @Nullable UUID uuid) {
        PacketSendingUtils.sendGroupedPacket(players, new SystemChatPacket(message, false), player -> Messenger.getChatMessageType(player).accepts(position));
    }

    public static boolean canReceiveMessage(@NotNull Player player) {
        return Messenger.getChatMessageType(player) == ChatMessageType.FULL;
    }

    public static boolean canReceiveCommand(@NotNull Player player) {
        return Messenger.getChatMessageType(player) != ChatMessageType.NONE;
    }

    public static void sendRejectionMessage(@NotNull Player player) {
        player.sendPacket(CANNOT_SEND_PACKET);
    }

    @NotNull
    private static ChatMessageType getChatMessageType(@NotNull Player player) {
        return Objects.requireNonNullElse(player.getSettings().chatMessageType(), ChatMessageType.FULL);
    }
}

