/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PolarBufferAccessWidener {
    private static final MethodHandle ADDRESS_GETTER;
    private static final MethodHandle ADDRESS_SETTER;

    @NotNull
    public static NetworkBuffer networkBufferView(@NotNull NetworkBuffer buffer, long start, long length) {
        NetworkBufferImpl viewBuffer = new NetworkBufferImpl(-1L, length, 0L, 0L, null, NetworkBufferImpl.impl((NetworkBuffer)buffer).registries);
        PolarBufferAccessWidener.setAddress(NetworkBufferImpl.impl(viewBuffer), PolarBufferAccessWidener.getAddress(NetworkBufferImpl.impl(buffer)) + start);
        viewBuffer.writeIndex(length);
        viewBuffer.readOnly();
        return viewBuffer;
    }

    public static long networkBufferAddress(@NotNull NetworkBuffer buffer) {
        return PolarBufferAccessWidener.getAddress(NetworkBufferImpl.impl(buffer));
    }

    private static long getAddress(@NotNull NetworkBufferImpl impl) {
        try {
            return ADDRESS_GETTER.invokeExact(impl);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void setAddress(@NotNull NetworkBufferImpl impl, long address) {
        try {
            ADDRESS_SETTER.invokeExact(impl, address);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(NetworkBufferImpl.class, MethodHandles.lookup());
            Field field = NetworkBufferImpl.class.getDeclaredField("address");
            ADDRESS_GETTER = lookup.unreflectGetter(field);
            ADDRESS_SETTER = lookup.unreflectSetter(field);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

