/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.client.play;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.client.ClientPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ClientEditBookPacket(int slot, @NotNull List<String> pages, @Nullable String title) implements ClientPacket
{
    public static final int MAX_PAGES = 100;
    public static final int MAX_TITLE_LENGTH = 32;
    public static final int MAX_PAGE_LENGTH = 1024;
    public static final NetworkBuffer.Type<ClientEditBookPacket> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, ClientEditBookPacket::slot, NetworkBuffer.STRING.list(100), ClientEditBookPacket::pages, NetworkBuffer.STRING.optional(), ClientEditBookPacket::title, ClientEditBookPacket::new);

    public ClientEditBookPacket(int slot, @NotNull List<String> pages, @Nullable String title) {
        for (String page : pages) {
            if (page.length() <= 1024) continue;
            throw new IllegalArgumentException("Page length cannot be greater than 1024");
        }
        if (title != null && title.length() > 32) {
            throw new IllegalArgumentException("Title length cannot be greater than 32");
        }
        pages = List.copyOf(pages);
    }
}

