/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record EntityEquipmentPacket(int entityId, @NotNull Map<EquipmentSlot, ItemStack> equipments) implements ServerPacket.Play,
ServerPacket.ComponentHolding
{
    public static final NetworkBuffer.Type<EntityEquipmentPacket> SERIALIZER = new NetworkBuffer.Type<EntityEquipmentPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, EntityEquipmentPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            int index = 0;
            for (Map.Entry<EquipmentSlot, ItemStack> entry : value.equipments.entrySet()) {
                boolean last = index++ == value.equipments.size() - 1;
                byte slotEnum = (byte)entry.getKey().legacyProtocolId();
                if (!last) {
                    slotEnum = (byte)(slotEnum | 0x80);
                }
                buffer.write(NetworkBuffer.BYTE, slotEnum);
                buffer.write(ItemStack.NETWORK_TYPE, entry.getValue());
            }
        }

        @Override
        public EntityEquipmentPacket read(@NotNull NetworkBuffer buffer) {
            return new EntityEquipmentPacket(buffer.read(NetworkBuffer.VAR_INT), EntityEquipmentPacket.readEquipments(buffer));
        }
    };

    public EntityEquipmentPacket(int entityId, @NotNull Map<EquipmentSlot, ItemStack> equipments) {
        equipments = Map.copyOf(equipments);
        if (equipments.isEmpty()) {
            throw new IllegalArgumentException("Equipments cannot be empty");
        }
    }

    @Override
    @NotNull
    public Collection<Component> components() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (ItemStack itemStack : this.equipments.values()) {
            components.addAll(ItemStack.textComponents(itemStack));
        }
        return List.copyOf(components);
    }

    @Override
    @NotNull
    public ServerPacket copyWithOperator(@NotNull UnaryOperator<Component> operator) {
        EnumMap<EquipmentSlot, ItemStack> newEquipment = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        for (Map.Entry<EquipmentSlot, ItemStack> entry : this.equipments.entrySet()) {
            newEquipment.put(entry.getKey(), ItemStack.copyWithOperator(entry.getValue(), operator));
        }
        return new EntityEquipmentPacket(this.entityId, newEquipment);
    }

    private static Map<EquipmentSlot, ItemStack> readEquipments(@NotNull NetworkBuffer reader) {
        byte slot;
        EnumMap<EquipmentSlot, ItemStack> equipments = new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
        do {
            slot = reader.read(NetworkBuffer.BYTE);
            equipments.put(EquipmentSlot.fromLegacyProtocolId(slot & 0x7F), reader.read(ItemStack.NETWORK_TYPE));
        } while ((slot & 0x80) == 128);
        return equipments;
    }
}

