/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record EntityRotationPacket(int entityId, float yaw, float pitch, boolean onGround) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<EntityRotationPacket> SERIALIZER = new NetworkBuffer.Type<EntityRotationPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, EntityRotationPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            buffer.write(NetworkBuffer.BYTE, (byte)(value.yaw * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BYTE, (byte)(value.pitch * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BOOLEAN, value.onGround);
        }

        @Override
        public EntityRotationPacket read(@NotNull NetworkBuffer buffer) {
            return new EntityRotationPacket(buffer.read(NetworkBuffer.VAR_INT), (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
}

