/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record EntityTeleportPacket(int entityId, Pos position, Point delta, int flags, boolean onGround) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<EntityTeleportPacket> SERIALIZER = new NetworkBuffer.Type<EntityTeleportPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, @NotNull EntityTeleportPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            buffer.write(NetworkBuffer.VECTOR3D, value.position.asVec());
            buffer.write(NetworkBuffer.VECTOR3D, value.delta);
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.position.yaw()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.position.pitch()));
            buffer.write(NetworkBuffer.INT, value.flags);
            buffer.write(NetworkBuffer.BOOLEAN, value.onGround);
        }

        @Override
        @NotNull
        public EntityTeleportPacket read(@NotNull NetworkBuffer buffer) {
            int entityId = buffer.read(NetworkBuffer.VAR_INT);
            Point absPosition = buffer.read(NetworkBuffer.VECTOR3D);
            Point deltaMovement = buffer.read(NetworkBuffer.VECTOR3D);
            return new EntityTeleportPacket(entityId, new Pos(absPosition, buffer.read(NetworkBuffer.FLOAT).floatValue(), buffer.read(NetworkBuffer.FLOAT).floatValue()), deltaMovement, buffer.read(NetworkBuffer.INT), buffer.read(NetworkBuffer.BOOLEAN));
        }
    };
}

