/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.kyori.adventure.text.Component;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record MapDataPacket(int mapId, byte scale, boolean locked, boolean trackingPosition, @NotNull List<Icon> icons, @Nullable ColorContent colorContent) implements ServerPacket.Play
{
    public static final int MAX_ICONS = 1024;
    public static final NetworkBuffer.Type<MapDataPacket> SERIALIZER = new NetworkBuffer.Type<MapDataPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, MapDataPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.mapId);
            buffer.write(NetworkBuffer.BYTE, value.scale);
            buffer.write(NetworkBuffer.BOOLEAN, value.locked);
            buffer.write(NetworkBuffer.BOOLEAN, value.trackingPosition);
            if (value.trackingPosition) {
                buffer.write(Icon.SERIALIZER.list(), value.icons);
            }
            if (value.colorContent != null) {
                buffer.write(ColorContent.SERIALIZER, value.colorContent);
            } else {
                buffer.write(NetworkBuffer.BYTE, (byte)0);
            }
        }

        @Override
        public MapDataPacket read(@NotNull NetworkBuffer buffer) {
            Integer mapId = buffer.read(NetworkBuffer.VAR_INT);
            Byte scale = buffer.read(NetworkBuffer.BYTE);
            Boolean locked = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean trackingPosition = buffer.read(NetworkBuffer.BOOLEAN);
            List<Icon> icons = trackingPosition != false ? buffer.read(Icon.SERIALIZER.list(1024)) : List.of();
            Byte columns = buffer.read(NetworkBuffer.BYTE);
            if (columns <= 0) {
                return new MapDataPacket(mapId, scale, locked, trackingPosition, icons, null);
            }
            byte rows = buffer.read(NetworkBuffer.BYTE);
            byte x = buffer.read(NetworkBuffer.BYTE);
            byte z = buffer.read(NetworkBuffer.BYTE);
            byte[] data = buffer.read(NetworkBuffer.BYTE_ARRAY);
            return new MapDataPacket(mapId, scale, locked, trackingPosition, icons, new ColorContent(columns, rows, x, z, data));
        }
    };

    public MapDataPacket(int mapId, byte scale, boolean locked, boolean trackingPosition, @NotNull List<Icon> icons, @Nullable ColorContent colorContent) {
        icons = List.copyOf(icons);
    }

    public record ColorContent(byte columns, byte rows, byte x, byte z, byte @NotNull [] data) {
        public static final NetworkBuffer.Type<ColorContent> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.BYTE, ColorContent::columns, NetworkBuffer.BYTE, ColorContent::rows, NetworkBuffer.BYTE, ColorContent::x, NetworkBuffer.BYTE, ColorContent::z, NetworkBuffer.BYTE_ARRAY, ColorContent::data, ColorContent::new);
    }

    public record Icon(int type, byte x, byte z, byte direction, @Nullable Component displayName) {
        public static final NetworkBuffer.Type<Icon> SERIALIZER = NetworkBufferTemplate.template(NetworkBuffer.VAR_INT, Icon::type, NetworkBuffer.BYTE, Icon::x, NetworkBuffer.BYTE, Icon::z, NetworkBuffer.BYTE, Icon::direction, NetworkBuffer.COMPONENT.optional(), Icon::displayName, Icon::new);
    }
}

