/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.Objects;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.particle.Particle;
import org.jetbrains.annotations.NotNull;

public record ParticlePacket(@NotNull Particle particle, boolean overrideLimiter, boolean longDistance, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float maxSpeed, int particleCount) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<ParticlePacket> SERIALIZER = new NetworkBuffer.Type<ParticlePacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, ParticlePacket value) {
            buffer.write(NetworkBuffer.BOOLEAN, value.overrideLimiter);
            buffer.write(NetworkBuffer.BOOLEAN, value.longDistance);
            buffer.write(NetworkBuffer.DOUBLE, value.x);
            buffer.write(NetworkBuffer.DOUBLE, value.y);
            buffer.write(NetworkBuffer.DOUBLE, value.z);
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.offsetX));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.offsetY));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.offsetZ));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.maxSpeed));
            buffer.write(NetworkBuffer.INT, value.particleCount);
            buffer.write(NetworkBuffer.VAR_INT, value.particle.id());
            value.particle.writeData(buffer);
        }

        @Override
        public ParticlePacket read(@NotNull NetworkBuffer buffer) {
            Boolean overrideLimiter = buffer.read(NetworkBuffer.BOOLEAN);
            Boolean longDistance = buffer.read(NetworkBuffer.BOOLEAN);
            Double x = buffer.read(NetworkBuffer.DOUBLE);
            Double y = buffer.read(NetworkBuffer.DOUBLE);
            Double z = buffer.read(NetworkBuffer.DOUBLE);
            Float offsetX = buffer.read(NetworkBuffer.FLOAT);
            Float offsetY = buffer.read(NetworkBuffer.FLOAT);
            Float offsetZ = buffer.read(NetworkBuffer.FLOAT);
            Float maxSpeed = buffer.read(NetworkBuffer.FLOAT);
            Integer particleCount = buffer.read(NetworkBuffer.INT);
            Particle particle = Particle.fromId(buffer.read(NetworkBuffer.VAR_INT));
            Objects.requireNonNull(particle);
            return new ParticlePacket(particle.readData(buffer), overrideLimiter, longDistance, x, y, z, offsetX.floatValue(), offsetY.floatValue(), offsetZ.floatValue(), maxSpeed.floatValue(), particleCount);
        }
    };

    public ParticlePacket(@NotNull Particle particle, double x, double y, double z, float offsetX, float offsetY, float offsetZ, float maxSpeed, int particleCount) {
        this(particle, false, false, x, y, z, offsetX, offsetY, offsetZ, maxSpeed, particleCount);
    }

    public ParticlePacket(@NotNull Particle particle, boolean overrideLimiter, boolean longDistance, @NotNull Point position, @NotNull Point offset, float maxSpeed, int particleCount) {
        this(particle, overrideLimiter, longDistance, position.x(), position.y(), position.z(), (float)offset.x(), (float)offset.y(), (float)offset.z(), maxSpeed, particleCount);
    }

    public ParticlePacket(@NotNull Particle particle, @NotNull Point position, @NotNull Point offset, float maxSpeed, int particleCount) {
        this(particle, false, false, position, offset, maxSpeed, particleCount);
    }
}

