/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import net.kyori.adventure.sound.Sound;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.coordinate.Point;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.sound.SoundEvent;
import org.jetbrains.annotations.NotNull;

public record SoundEffectPacket(@NotNull SoundEvent soundEvent, @NotNull Sound.Source source, int x, int y, int z, float volume, float pitch, long seed) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<SoundEffectPacket> SERIALIZER = new NetworkBuffer.Type<SoundEffectPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, SoundEffectPacket value) {
            buffer.write(SoundEvent.NETWORK_TYPE, value.soundEvent());
            buffer.write(NetworkBuffer.VAR_INT, AdventurePacketConvertor.getSoundSourceValue(value.source()));
            buffer.write(NetworkBuffer.INT, value.x() * 8);
            buffer.write(NetworkBuffer.INT, value.y() * 8);
            buffer.write(NetworkBuffer.INT, value.z() * 8);
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.volume()));
            buffer.write(NetworkBuffer.FLOAT, Float.valueOf(value.pitch()));
            buffer.write(NetworkBuffer.LONG, value.seed());
        }

        @Override
        public SoundEffectPacket read(@NotNull NetworkBuffer buffer) {
            return new SoundEffectPacket(buffer.read(SoundEvent.NETWORK_TYPE), buffer.read(NetworkBuffer.Enum(Sound.Source.class)), buffer.read(NetworkBuffer.INT) * 8, buffer.read(NetworkBuffer.INT) * 8, buffer.read(NetworkBuffer.INT) * 8, buffer.read(NetworkBuffer.FLOAT).floatValue(), buffer.read(NetworkBuffer.FLOAT).floatValue(), buffer.read(NetworkBuffer.LONG));
        }
    };

    public SoundEffectPacket(@NotNull SoundEvent soundEvent, @NotNull Sound.Source source, @NotNull Point position, float volume, float pitch, long seed) {
        this(soundEvent, source, position.blockX(), position.blockY(), position.blockZ(), volume, pitch, seed);
    }
}

