/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.ServerFlag;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.network.packet.server.CachedPacket;
import net.minestom.server.network.packet.server.SendablePacket;
import net.minestom.server.network.packet.server.configuration.RegistryDataPacket;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@ApiStatus.Internal
final class DynamicRegistryImpl<T>
implements DynamicRegistry<T> {
    private static final UnsupportedOperationException UNSAFE_REMOVE_EXCEPTION = new UnsupportedOperationException("Unsafe remove is disabled. Enable by setting the system property 'minestom.registry.unsafe-ops' to 'true'");
    private Registries registries = null;
    private CachedPacket vanillaRegistryDataPacket = new CachedPacket(() -> this.createRegistryDataPacket(this.registries, true));
    private final ReentrantLock lock = new ReentrantLock();
    private final List<T> entryById = new CopyOnWriteArrayList<T>();
    private final Map<Key, T> entryByName = new ConcurrentHashMap<Key, T>();
    private final List<Key> idByName = new CopyOnWriteArrayList<Key>();
    private final List<DataPack> packById = new CopyOnWriteArrayList<DataPack>();
    private final String id;
    private final Codec<T> codec;

    DynamicRegistryImpl(@NotNull String id, @Nullable Codec<T> codec) {
        this.id = id;
        this.codec = codec;
    }

    @Override
    @NotNull
    public String id() {
        return this.id;
    }

    public @UnknownNullability Codec<T> codec() {
        return this.codec;
    }

    @Override
    @Nullable
    public T get(int id) {
        if (id < 0 || id >= this.entryById.size()) {
            return null;
        }
        return this.entryById.get(id);
    }

    @Override
    @Nullable
    public T get(@NotNull Key namespace) {
        return this.entryByName.get(namespace);
    }

    @Override
    @Nullable
    public DynamicRegistry.Key<T> getKey(@NotNull T value) {
        int index = this.entryById.indexOf(value);
        return index == -1 ? null : this.getKey(index);
    }

    @Override
    @Nullable
    public DynamicRegistry.Key<T> getKey(int id) {
        if (id < 0 || id >= this.entryById.size()) {
            return null;
        }
        return DynamicRegistry.Key.of(this.idByName.get(id));
    }

    @Override
    @Nullable
    public Key getName(int id) {
        if (id < 0 || id >= this.entryById.size()) {
            return null;
        }
        return this.idByName.get(id);
    }

    @Override
    @Nullable
    public DataPack getPack(int id) {
        if (id < 0 || id >= this.packById.size()) {
            return null;
        }
        return this.packById.get(id);
    }

    @Override
    public int getId(@NotNull Key id) {
        return this.idByName.indexOf(id);
    }

    @Override
    @NotNull
    public List<T> values() {
        return Collections.unmodifiableList(this.entryById);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public DynamicRegistry.Key<T> register(@NotNull Key namespaceId, @NotNull T object, @Nullable DataPack pack) {
        this.lock.lock();
        try {
            int id = this.idByName.indexOf(namespaceId);
            this.entryByName.put(namespaceId, object);
            if (id == -1) {
                this.idByName.add(namespaceId);
                this.entryById.add(object);
                this.packById.add(pack);
            } else {
                this.idByName.set(id, namespaceId);
                this.entryById.set(id, object);
                this.packById.set(id, pack);
            }
            if (this.vanillaRegistryDataPacket != null) {
                this.vanillaRegistryDataPacket.invalidate();
            }
            DynamicRegistry.Key key = DynamicRegistry.Key.of(namespaceId);
            return key;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull Key namespaceId) throws UnsupportedOperationException {
        if (!ServerFlag.REGISTRY_UNSAFE_OPS) {
            throw UNSAFE_REMOVE_EXCEPTION;
        }
        this.lock.lock();
        try {
            int id = this.idByName.indexOf(namespaceId);
            if (id == -1) {
                boolean bl = false;
                return bl;
            }
            this.entryById.remove(id);
            this.entryByName.remove(namespaceId);
            this.idByName.remove(id);
            this.packById.remove(id);
            if (this.vanillaRegistryDataPacket != null) {
                this.vanillaRegistryDataPacket.invalidate();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NotNull
    public SendablePacket registryDataPacket(@NotNull Registries registries, boolean excludeVanilla) {
        if (excludeVanilla) {
            if (this.registries != registries) {
                this.vanillaRegistryDataPacket.invalidate();
                this.registries = registries;
            }
            return this.vanillaRegistryDataPacket;
        }
        return this.createRegistryDataPacket(registries, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private RegistryDataPacket createRegistryDataPacket(@NotNull Registries registries, boolean excludeVanilla) {
        Check.notNull(this.codec, "Cannot create registry data packet for server-only registry");
        RegistryTranscoder<BinaryTag> transcoder = new RegistryTranscoder<BinaryTag>(Transcoder.NBT, registries);
        ArrayList<RegistryDataPacket.Entry> entries = new ArrayList<RegistryDataPacket.Entry>(this.entryById.size());
        int i = 0;
        while (i < this.entryById.size()) {
            CompoundBinaryTag data = null;
            T entry = this.entryById.get(i);
            DataPack pack = this.packById.get(i);
            if (!excludeVanilla || pack != DataPack.MINECRAFT_CORE) {
                BinaryTag tag;
                Result<BinaryTag> entryResult = this.codec.encode(transcoder, entry);
                if (!(entryResult instanceof Result.Ok)) {
                    throw new IllegalStateException("Failed to encode registry entry " + i + " (" + String.valueOf(this.getKey(i)) + ") for registry " + this.id);
                }
                Result.Ok ok = (Result.Ok)entryResult;
                try {
                    BinaryTag binaryTag;
                    tag = binaryTag = (BinaryTag)ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                data = (CompoundBinaryTag)tag;
            }
            entries.add(new RegistryDataPacket.Entry(this.getKey(i).name(), data));
            ++i;
        }
        return new RegistryDataPacket(this.id, entries);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <T> void loadStaticJsonRegistry(@Nullable Registries registries, @NotNull DynamicRegistryImpl<T> registry, @NotNull Registry.Resource resource, @Nullable Comparator<String> idComparator) {
        Check.argCondition(!resource.fileName().endsWith(".json"), "Resource must be a JSON file: {0}", resource.fileName());
        try (InputStream resourceStream = Registry.loadRegistryFile(resource);){
            Check.notNull(resourceStream, "Resource {0} does not exist!", new Object[]{resource});
            JsonElement json = Registry.GSON.fromJson((Reader)new InputStreamReader(resourceStream, StandardCharsets.UTF_8), JsonElement.class);
            if (!(json instanceof JsonObject)) {
                throw new IllegalStateException("Failed to load registry " + registry.id() + ": expected a JSON object, got " + String.valueOf(json));
            }
            JsonObject root = (JsonObject)json;
            RegistryTranscoder<JsonElement> transcoder = registries != null ? new RegistryTranscoder<JsonElement>(Transcoder.JSON, registries) : Transcoder.JSON;
            ArrayList<Map.Entry<String, JsonElement>> entries = new ArrayList<Map.Entry<String, JsonElement>>(root.entrySet());
            if (idComparator != null) {
                entries.sort(Map.Entry.comparingByKey(idComparator));
            }
            for (Map.Entry entry : entries) {
                Object value;
                String namespace = (String)entry.getKey();
                Result valueResult = registry.codec().decode(transcoder, (JsonElement)entry.getValue());
                if (!(valueResult instanceof Result.Ok)) throw new IllegalStateException("Failed to decode registry entry " + namespace + " for registry " + registry.id() + ": " + String.valueOf(valueResult));
                Result.Ok ok = (Result.Ok)valueResult;
                try {
                    Object t;
                    value = t = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                    return;
                }
                registry.register(namespace, value, DataPack.MINECRAFT_CORE);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    record KeyImpl<T>(@NotNull Key key) implements DynamicRegistry.Key<T>
    {
        @Override
        public String toString() {
            return this.key.asString();
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            KeyImpl key = (KeyImpl)obj;
            return this.key.equals(key.key);
        }
    }
}

