/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.key.Key;
import net.minestom.server.MinecraftServer;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.gamedata.tags.Tag;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.ObjectSet;
import net.minestom.server.registry.ProtocolObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

sealed interface ObjectSetImpl<T extends ProtocolObject>
extends ObjectSet<T> {

    public record CodecImpl<T extends ProtocolObject>(@NotNull Tag.BasicType tagType) implements Codec<ObjectSet<T>>
    {
        private static final Codec<Entries<?>> ENTRIES_CODEC = Codec.KEY.list().transform(Entries::new, Entries::entries);

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<ObjectSet<T>> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            String string;
            Result entriesResult = ENTRIES_CODEC.decode(coder, value);
            if (entriesResult instanceof Result.Ok) {
                Entries entries;
                Result.Ok ok = (Result.Ok)entriesResult;
                Entries entries2 = entries = (Entries)ok.value();
                return new Result.Ok<ObjectSet<T>>(entries2);
            }
            Result<String> stringResult = coder.getString(value);
            if (!(stringResult instanceof Result.Ok)) return stringResult.cast();
            Result.Ok ok = (Result.Ok)stringResult;
            try {
                String string2;
                string = string2 = (String)ok.value();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return new Result.Ok<ObjectSet<T>>(string.startsWith("#") ? new Tag(this.tagType(), string.substring(1)) : new Entries(List.of(Key.key(string))));
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable ObjectSet<T> value) {
            if (value == null) {
                return new Result.Error("null");
            }
            ObjectSet<T> objectSet = value;
            Objects.requireNonNull(objectSet);
            ObjectSet<T> objectSet2 = objectSet;
            int n = 0;
            return new Result.Ok<D>(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Empty.class, Entries.class, Tag.class}, objectSet2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    Empty empty = (Empty)objectSet2;
                    yield coder.emptyList();
                }
                case 1 -> {
                    Entries entries = (Entries)objectSet2;
                    if (entries.entries.size() == 1) {
                        yield coder.createString(((Key)entries.entries.stream().findFirst().get()).asString());
                    }
                    Transcoder.ListBuilder<D> list = coder.createList(entries.entries.size());
                    for (Key entry : entries.entries) {
                        list.add(coder.createString(entry.asString()));
                    }
                    yield list.build();
                }
                case 2 -> {
                    Tag tag = (Tag)objectSet2;
                    yield coder.createString("#" + tag.name());
                }
            });
        }
    }

    public record NetworkType<T extends ProtocolObject>(@NotNull Tag.BasicType tagType) implements NetworkBuffer.Type<ObjectSet<T>>
    {
        @Override
        public void write(@NotNull NetworkBuffer buffer, ObjectSet<T> value) {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public ObjectSet<T> read(@NotNull NetworkBuffer buffer) {
            throw new UnsupportedOperationException("todo");
        }
    }

    public static final class Tag<T extends ProtocolObject>
    implements ObjectSetImpl<T> {
        private final Tag.BasicType tagType;
        private final String name;
        private volatile Set<Key> value = null;

        public Tag(@NotNull Tag.BasicType tagType, @NotNull String name) {
            this.tagType = tagType;
            this.name = name;
        }

        public Tag(@NotNull net.minestom.server.gamedata.tags.Tag tag) {
            this.tagType = null;
            this.name = tag.name();
            this.value = Set.copyOf(tag.getValues());
        }

        @NotNull
        public String name() {
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Key> value() {
            if (this.value == null) {
                Tag tag = this;
                synchronized (tag) {
                    if (this.value == null) {
                        net.minestom.server.gamedata.tags.Tag group = MinecraftServer.getTagManager().getTag(this.tagType, this.name);
                        this.value = group == null ? Set.of() : Set.copyOf(group.getValues());
                    }
                }
            }
            return this.value;
        }

        @Override
        public boolean contains(@NotNull Key key) {
            return this.value().contains(key);
        }
    }

    public record Entries<T extends ProtocolObject>(@NotNull List<Key> entries) implements ObjectSetImpl<T>
    {
        public Entries(@NotNull List<Key> entries) {
            entries = List.copyOf(entries);
        }

        @Override
        public boolean contains(@NotNull Key key) {
            return this.entries.contains(key);
        }
    }

    public record Empty<T extends ProtocolObject>() implements ObjectSetImpl<T>
    {
        static final Empty<?> INSTANCE = new Empty();

        @Override
        public boolean contains(@NotNull Key namespace) {
            return false;
        }
    }
}

