/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.minestom.server.MinecraftServer;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.Shape;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.EntityType;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockSoundType;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.Equippable;
import net.minestom.server.registry.ProtocolObject;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.collection.ObjectArray;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Registry {
    static final Gson GSON = new GsonBuilder().disableHtmlEscaping().disableJdkUnsafe().create();

    @ApiStatus.Internal
    public static BlockEntry block(String namespace, @NotNull Properties main) {
        return new BlockEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static MaterialEntry material(String namespace, @NotNull Properties main) {
        return new MaterialEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static EntityEntry entity(String namespace, @NotNull Properties main) {
        return new EntityEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static VillagerProfessionEntry villagerProfession(String namespace, @NotNull Properties main) {
        return new VillagerProfessionEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static FeatureFlagEntry featureFlag(String namespace, @NotNull Properties main) {
        return new FeatureFlagEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static PotionEffectEntry potionEffect(String namespace, @NotNull Properties main) {
        return new PotionEffectEntry(namespace, main, null);
    }

    @ApiStatus.Internal
    public static AttributeEntry attribute(String namespace, @NotNull Properties main) {
        return new AttributeEntry(namespace, main, null);
    }

    public static GameEventEntry gameEventEntry(String namespace, Properties properties) {
        return new GameEventEntry(namespace, properties, null);
    }

    public static BlockSoundTypeEntry blockSoundTypeEntry(String namespace, Properties properties) {
        return new BlockSoundTypeEntry(namespace, properties);
    }

    @NotNull
    public static InputStream loadRegistryFile(@NotNull Resource resource) throws IOException {
        InputStream resourceStream = Registry.class.getClassLoader().getResourceAsStream(resource.name);
        if (resourceStream == null && Files.exists(Path.of(resource.name, new String[0]), new LinkOption[0])) {
            resourceStream = Files.newInputStream(Path.of(resource.name, new String[0]), new OpenOption[0]);
        }
        Check.notNull(resourceStream, "Resource {0} does not exist!", new Object[]{resource});
        return resourceStream;
    }

    @ApiStatus.Internal
    public static Map<String, Map<String, Object>> load(Resource resource) {
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        try (InputStream resourceStream = Registry.loadRegistryFile(resource);
             JsonReader reader = new JsonReader(new InputStreamReader(resourceStream));){
            reader.beginObject();
            while (reader.hasNext()) {
                map.put(reader.nextName(), (Map)Registry.readObject(reader));
            }
            reader.endObject();
        }
        catch (IOException e) {
            MinecraftServer.getExceptionManager().handleException(e);
        }
        return map;
    }

    @ApiStatus.Internal
    public static <T extends StaticProtocolObject> Container<T> createStaticContainer(Resource resource, Container.Loader<T> loader) {
        Map<String, Map<String, Object>> entries = Registry.load(resource);
        HashMap<String, StaticProtocolObject> namespaces = new HashMap<String, StaticProtocolObject>(entries.size());
        ObjectArray<StaticProtocolObject> ids = ObjectArray.singleThread(entries.size());
        for (Map.Entry<String, Map<String, Object>> entry : entries.entrySet()) {
            String namespace = entry.getKey();
            Properties properties = Properties.fromMap(entry.getValue());
            StaticProtocolObject value = (StaticProtocolObject)loader.get(namespace, properties);
            ids.set(value.id(), value);
            namespaces.put(value.name(), value);
        }
        return new Container(resource, namespaces, ids);
    }

    private static Object readObject(JsonReader reader) throws IOException {
        return switch (reader.peek()) {
            case JsonToken.BEGIN_ARRAY -> {
                ArrayList<Object> list = new ArrayList<Object>();
                reader.beginArray();
                while (reader.hasNext()) {
                    list.add(Registry.readObject(reader));
                }
                reader.endArray();
                yield list;
            }
            case JsonToken.BEGIN_OBJECT -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                reader.beginObject();
                while (reader.hasNext()) {
                    map.put(reader.nextName(), Registry.readObject(reader));
                }
                reader.endObject();
                yield map;
            }
            case JsonToken.STRING -> reader.nextString();
            case JsonToken.NUMBER -> ToNumberPolicy.LONG_OR_DOUBLE.readNumber(reader);
            case JsonToken.BOOLEAN -> reader.nextBoolean();
            default -> throw new IllegalStateException("Invalid peek: " + String.valueOf((Object)reader.peek()));
        };
    }

    public static final class BlockEntry
    implements Entry {
        private final Key key;
        private final int id;
        private final int stateId;
        private final String translationKey;
        private final double hardness;
        private final double explosionResistance;
        private final double friction;
        private final double speedFactor;
        private final double jumpFactor;
        private final boolean air;
        private final boolean solid;
        private final boolean liquid;
        private final boolean occludes;
        private final boolean requiresTool;
        private final int lightEmission;
        private final boolean replaceable;
        private final String blockEntity;
        private final int blockEntityId;
        private final Supplier<Material> materialSupplier;
        private final BlockSoundType blockSoundType;
        private final Shape shape;
        private final boolean redstoneConductor;
        private final boolean signalSource;
        private final Properties custom;

        private BlockEntry(String namespace, Properties main, Properties custom) {
            this.custom = custom;
            this.key = Key.key(namespace);
            this.id = main.getInt("id");
            this.stateId = main.getInt("stateId");
            this.translationKey = main.getString("translationKey");
            this.hardness = main.getDouble("hardness");
            this.explosionResistance = main.getDouble("explosionResistance");
            this.friction = main.getDouble("friction");
            this.speedFactor = main.getDouble("speedFactor", 1.0);
            this.jumpFactor = main.getDouble("jumpFactor", 1.0);
            this.air = main.getBoolean("air", false);
            this.solid = main.getBoolean("solid");
            this.liquid = main.getBoolean("liquid", false);
            this.occludes = main.getBoolean("occludes", true);
            this.requiresTool = main.getBoolean("requiresTool", true);
            this.lightEmission = main.getInt("lightEmission", 0);
            this.replaceable = main.getBoolean("replaceable", false);
            this.blockSoundType = BlockSoundType.fromKey(main.getString("soundType"));
            Properties blockEntity = main.section("blockEntity");
            if (blockEntity != null) {
                this.blockEntity = blockEntity.getString("namespace");
                this.blockEntityId = blockEntity.getInt("id");
            } else {
                this.blockEntity = null;
                this.blockEntityId = 0;
            }
            String materialNamespace = main.getString("correspondingItem", null);
            this.materialSupplier = materialNamespace != null ? () -> Material.fromKey(materialNamespace) : () -> null;
            String collision = main.getString("collisionShape");
            String occlusion = main.getString("occlusionShape");
            this.shape = CollisionUtils.parseBlockShape(collision, occlusion, this);
            this.redstoneConductor = main.getBoolean("redstoneConductor");
            this.signalSource = main.getBoolean("signalSource", false);
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        public int stateId() {
            return this.stateId;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public double hardness() {
            return this.hardness;
        }

        public double explosionResistance() {
            return this.explosionResistance;
        }

        public double friction() {
            return this.friction;
        }

        public double speedFactor() {
            return this.speedFactor;
        }

        public double jumpFactor() {
            return this.jumpFactor;
        }

        public boolean isAir() {
            return this.air;
        }

        public boolean isSolid() {
            return this.solid;
        }

        public boolean isLiquid() {
            return this.liquid;
        }

        public boolean occludes() {
            return this.occludes;
        }

        public boolean requiresTool() {
            return this.requiresTool;
        }

        public int lightEmission() {
            return this.lightEmission;
        }

        public boolean isReplaceable() {
            return this.replaceable;
        }

        public boolean isBlockEntity() {
            return this.blockEntity != null;
        }

        @Nullable
        public String blockEntity() {
            return this.blockEntity;
        }

        public int blockEntityId() {
            return this.blockEntityId;
        }

        @Nullable
        public Material material() {
            return this.materialSupplier.get();
        }

        public boolean isRedstoneConductor() {
            return this.redstoneConductor;
        }

        public boolean isSignalSource() {
            return this.signalSource;
        }

        public Shape collisionShape() {
            return this.shape;
        }

        @Nullable
        public BlockSoundType getBlockSoundType() {
            return this.blockSoundType;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public static interface Properties
    extends Iterable<Map.Entry<String, Object>> {
        public static Properties fromMap(Map<String, Object> map) {
            return new PropertiesMap(map);
        }

        public String getString(String var1, String var2);

        public String getString(String var1);

        public double getDouble(String var1, double var2);

        public double getDouble(String var1);

        public int getInt(String var1, int var2);

        public int getInt(String var1);

        public float getFloat(String var1, float var2);

        public float getFloat(String var1);

        public boolean getBoolean(String var1, boolean var2);

        public boolean getBoolean(String var1);

        public List<List<Double>> getNestedDoubleArray(String var1);

        public Properties section(String var1);

        public boolean containsKey(String var1);

        public Map<String, Object> asMap();

        @Override
        @NotNull
        default public Iterator<Map.Entry<String, Object>> iterator() {
            return this.asMap().entrySet().iterator();
        }

        default public int size() {
            return this.asMap().size();
        }
    }

    public static final class MaterialEntry
    implements Entry {
        private final Key key;
        private final Properties main;
        private final int id;
        private final String translationKey;
        private final Supplier<Block> blockSupplier;
        private DataComponentMap prototype;
        private final EntityType entityType;
        private final Properties custom;

        private MaterialEntry(String namespace, Properties main, Properties custom) {
            this.main = main;
            this.custom = custom;
            this.key = Key.key(namespace);
            this.id = main.getInt("id");
            this.translationKey = main.getString("translationKey");
            String blockNamespace = main.getString("correspondingBlock", null);
            this.blockSupplier = blockNamespace != null ? () -> Block.fromKey(blockNamespace) : () -> null;
            Properties spawnEggProperties = main.section("spawnEggProperties");
            this.entityType = spawnEggProperties != null ? EntityType.fromKey(spawnEggProperties.getString("entityType")) : null;
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        @NotNull
        public String translationKey() {
            return this.translationKey;
        }

        @Nullable
        public Block block() {
            return this.blockSupplier.get();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        @NotNull
        public DataComponentMap prototype() {
            String message;
            Result.Error error;
            Result result;
            Map.Entry<String, Object> entry;
            if (this.prototype != null) return this.prototype;
            RegistryTranscoder<Object> coder = new RegistryTranscoder<Object>(Transcoder.JAVA, MinecraftServer.process());
            DataComponentMap.Builder builder = DataComponentMap.builder();
            Iterator<Map.Entry<String, Object>> iterator = this.main.section("components").iterator();
            block7: while (true) {
                if (!iterator.hasNext()) {
                    this.prototype = builder.build();
                    return this.prototype;
                }
                entry = iterator.next();
                DataComponent<?> component = DataComponent.fromKey(entry.getKey());
                Check.notNull(component, "Unknown component {0} in {1}", entry.getKey(), this.key);
                Result result2 = component.decode(coder, entry.getValue());
                Objects.requireNonNull(result2);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Result.Ok ok = (Result.Ok)result;
                        Result.Error ok2 = error = ok.value();
                        builder.set(component, ok2);
                        continue block7;
                    }
                    case 1: 
                }
                break;
            }
            error = (Result.Error)result;
            try {
                String string;
                message = string = error.message();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            throw new IllegalStateException("Failed to decode component " + entry.getKey() + " in " + String.valueOf(this.key) + ": " + message);
        }

        public boolean isArmor() {
            Equippable equippableComponent = this.prototype.get(DataComponents.EQUIPPABLE);
            EquipmentSlot equipmentSlot = equippableComponent == null ? null : equippableComponent.slot();
            return equipmentSlot != null && equipmentSlot.isArmor();
        }

        @Nullable
        public EquipmentSlot equipmentSlot() {
            Equippable equippableComponent = this.prototype.get(DataComponents.EQUIPPABLE);
            return equippableComponent == null ? null : equippableComponent.slot();
        }

        @Nullable
        public EntityType spawnEntityType() {
            return this.entityType;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public static final class EntityEntry
    implements Entry {
        private final Key key;
        private final int id;
        private final String translationKey;
        private final double drag;
        private final double acceleration;
        private final boolean isLiving;
        private final double width;
        private final double height;
        private final double eyeHeight;
        private final int clientTrackingRange;
        private final boolean fireImmune;
        private final Map<String, List<Double>> entityOffsets;
        private final BoundingBox boundingBox;
        private final Properties custom;

        public EntityEntry(String namespace, Properties main, Properties custom) {
            this.key = Key.key(namespace);
            this.id = main.getInt("id");
            this.translationKey = main.getString("translationKey");
            this.drag = main.getDouble("drag", 0.02);
            this.acceleration = main.getDouble("acceleration", 0.08);
            String packetType = main.getString("packetType").toUpperCase(Locale.ROOT);
            this.isLiving = "LIVING".equals(packetType) || "PLAYER".equals(packetType);
            this.fireImmune = main.getBoolean("fireImmune", false);
            this.clientTrackingRange = main.getInt("clientTrackingRange");
            this.width = main.getDouble("width");
            this.height = main.getDouble("height");
            this.eyeHeight = main.getDouble("eyeHeight");
            this.boundingBox = new BoundingBox(this.width, this.height, this.width);
            this.entityOffsets = new HashMap<String, List<Double>>();
            Properties attachments = main.section("attachments");
            if (attachments != null) {
                Set<String> allAttachments = attachments.asMap().keySet();
                for (String key : allAttachments) {
                    List<List<Double>> offset = attachments.getNestedDoubleArray(key);
                    this.entityOffsets.put(key, offset.getFirst());
                }
            }
            this.custom = custom;
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        public String translationKey() {
            return this.translationKey;
        }

        public double drag() {
            return this.drag;
        }

        public double acceleration() {
            return this.acceleration;
        }

        public double horizontalAirResistance() {
            return this.isLiving ? 0.91 : 0.98;
        }

        public double verticalAirResistance() {
            return 1.0 - this.drag();
        }

        public boolean shouldSendAttributes() {
            return this.isLiving;
        }

        public double width() {
            return this.width;
        }

        public double height() {
            return this.height;
        }

        public double eyeHeight() {
            return this.eyeHeight;
        }

        public boolean fireImmune() {
            return this.fireImmune;
        }

        public int clientTrackingRange() {
            return this.clientTrackingRange;
        }

        @Nullable
        public List<Double> entityAttachment(@NotNull String attachmentName) {
            return this.entityOffsets.get(attachmentName);
        }

        @NotNull
        public BoundingBox boundingBox() {
            return this.boundingBox;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public static final class VillagerProfessionEntry
    implements Entry {
        private final Key key;
        private final int id;
        private final SoundEvent workSound;
        private final Properties custom;

        public VillagerProfessionEntry(String namespace, Properties main, Properties custom) {
            this.key = Key.key(namespace);
            this.id = main.getInt("id");
            this.workSound = main.containsKey("workSound") ? SoundEvent.fromKey(main.getString("workSound")) : null;
            this.custom = custom;
        }

        @NotNull
        public Key key() {
            return this.key;
        }

        public int id() {
            return this.id;
        }

        @Nullable
        public SoundEvent workSound() {
            return this.workSound;
        }

        @Override
        public Properties custom() {
            return this.custom;
        }
    }

    public record FeatureFlagEntry(Key key, int id, Properties custom) implements Entry
    {
        public FeatureFlagEntry(String namespace, Properties main, Properties custom) {
            this(Key.key(namespace), main.getInt("id"), null);
        }
    }

    public record PotionEffectEntry(Key key, int id, String translationKey, int color, boolean isInstantaneous, Properties custom) implements Entry
    {
        public PotionEffectEntry(String namespace, Properties main, Properties custom) {
            this(Key.key(namespace), main.getInt("id"), main.getString("translationKey"), main.getInt("color"), main.getBoolean("instantaneous"), custom);
        }
    }

    public record AttributeEntry(Key key, int id, String translationKey, double defaultValue, boolean clientSync, double maxValue, double minValue, Properties custom) implements Entry
    {
        public AttributeEntry(String namespace, Properties main, Properties custom) {
            this(Key.key(namespace), main.getInt("id"), main.getString("translationKey"), main.getDouble("defaultValue"), main.getBoolean("clientSync"), main.getDouble("maxValue"), main.getDouble("minValue"), custom);
        }
    }

    public record GameEventEntry(Key key, Properties main, Properties custom) implements Entry
    {
        public GameEventEntry(String key, Properties main, Properties custom) {
            this(Key.key(key), main, custom);
        }
    }

    public record BlockSoundTypeEntry(@NotNull Key key, float volume, float pitch, SoundEvent breakSound, SoundEvent hitSound, SoundEvent fallSound, SoundEvent placeSound, SoundEvent stepSound) {
        public BlockSoundTypeEntry(String namespace, Properties main) {
            this(Key.key(namespace), main.getFloat("volume"), main.getFloat("pitch"), SoundEvent.fromKey(main.getString("breakSound")), SoundEvent.fromKey(main.getString("hitSound")), SoundEvent.fromKey(main.getString("fallSound")), SoundEvent.fromKey(main.getString("placeSound")), SoundEvent.fromKey(main.getString("stepSound")));
        }
    }

    @ApiStatus.Internal
    public static enum Resource {
        BLOCKS("blocks.json"),
        ITEMS("items.json"),
        ENTITIES("entities.json"),
        FEATURE_FLAGS("feature_flags.json"),
        SOUNDS("sounds.json"),
        STATISTICS("custom_statistics.json"),
        POTION_EFFECTS("potion_effects.json"),
        POTION_TYPES("potions.json"),
        PARTICLES("particles.json"),
        DAMAGE_TYPES("damage_types.json"),
        TRIM_MATERIALS("trim_materials.json"),
        TRIM_PATTERNS("trim_patterns.json"),
        BLOCK_TAGS("tags/block.json"),
        ENTITY_TYPE_TAGS("tags/entity_type.json"),
        FLUID_TAGS("tags/fluid.json"),
        GAMEPLAY_TAGS("tags/game_event.json"),
        GAME_EVENTS("game_events.json"),
        ITEM_TAGS("tags/item.json"),
        ENCHANTMENT_TAGS("tags/enchantment.json"),
        BIOME_TAGS("tags/biome.json"),
        DIMENSION_TYPES("dimension_types.json"),
        BIOMES("biomes.json"),
        ATTRIBUTES("attributes.json"),
        BANNER_PATTERNS("banner_patterns.json"),
        PAINTING_VARIANTS("painting_variants.json"),
        WOLF_VARIANTS("wolf_variants.json"),
        WOLF_SOUND_VARIANTS("wolf_sound_variants.json"),
        CAT_VARIANTS("cat_variants.json"),
        CHICKEN_VARIANTS("chicken_variants.json"),
        COW_VARIANTS("cow_variants.json"),
        FROG_VARIANTS("frog_variants.json"),
        PIG_VARIANTS("pig_variants.json"),
        CHAT_TYPES("chat_types.json"),
        ENCHANTMENTS("enchantments.json"),
        JUKEBOX_SONGS("jukebox_songs.json"),
        VILLAGER_PROFESSIONS("villager_professions.json"),
        INSTRUMENTS("instruments.json"),
        INSTRUMENT_TAGS("tags/instrument.json"),
        BLOCK_SOUND_TYPES("block_sound_types.json");

        private final String name;

        private Resource(String name) {
            this.name = name;
        }

        @NotNull
        public String fileName() {
            return this.name;
        }
    }

    @ApiStatus.Internal
    public record Container<T extends StaticProtocolObject>(Resource resource, Map<String, T> namespaces, ObjectArray<T> ids) {
        public Container {
            namespaces = Map.copyOf(namespaces);
            ids.trim();
        }

        public T get(@NotNull String namespace) {
            return (T)((StaticProtocolObject)this.namespaces.get(namespace));
        }

        public T getSafe(@NotNull String namespace) {
            return this.get((String)(namespace.contains(":") ? namespace : "minecraft:" + namespace));
        }

        public T getId(int id) {
            return (T)((StaticProtocolObject)this.ids.get(id));
        }

        public int toId(@NotNull String namespace) {
            return this.get(namespace).id();
        }

        public Collection<T> values() {
            return this.namespaces.values();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Container)) {
                return false;
            }
            Container container = (Container)o;
            return this.resource == container.resource;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.resource});
        }

        public static interface Loader<T extends ProtocolObject> {
            public T get(String var1, Properties var2);
        }
    }

    record PropertiesMap(Map<String, Object> map) implements Properties
    {
        @Override
        public String getString(String name, String defaultValue) {
            Object element = this.element(name);
            return element != null ? (String)element : defaultValue;
        }

        @Override
        public String getString(String name) {
            return (String)this.element(name);
        }

        @Override
        public double getDouble(String name, double defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).doubleValue() : defaultValue;
        }

        @Override
        public double getDouble(String name) {
            return ((Number)this.element(name)).doubleValue();
        }

        @Override
        public int getInt(String name, int defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).intValue() : defaultValue;
        }

        @Override
        public int getInt(String name) {
            return ((Number)this.element(name)).intValue();
        }

        @Override
        public float getFloat(String name, float defaultValue) {
            Object element = this.element(name);
            return element != null ? ((Number)element).floatValue() : defaultValue;
        }

        @Override
        public float getFloat(String name) {
            return ((Number)this.element(name)).floatValue();
        }

        @Override
        public boolean getBoolean(String name, boolean defaultValue) {
            Object element = this.element(name);
            return element != null ? (Boolean)element : defaultValue;
        }

        @Override
        public List<List<Double>> getNestedDoubleArray(String name) {
            Object element = this.element(name);
            return element != null ? (List)element : List.of();
        }

        @Override
        public boolean getBoolean(String name) {
            return (Boolean)this.element(name);
        }

        @Override
        public Properties section(String name) {
            Map map = (Map)this.element(name);
            if (map == null) {
                return null;
            }
            return new PropertiesMap(map);
        }

        @Override
        public boolean containsKey(String name) {
            return this.map.containsKey(name);
        }

        @Override
        public Map<String, Object> asMap() {
            return this.map;
        }

        private <T> T element(String name) {
            return (T)this.map.get(name);
        }

        @Override
        public String toString() {
            AtomicReference<String> string = new AtomicReference<String>("{ ");
            this.map.forEach((? super K s, ? super V object) -> string.set((String)string.get() + " , \"" + s + "\" : \"" + object.toString() + "\""));
            return string.updateAndGet(s -> s.replaceFirst(" , ", "") + "}");
        }
    }

    public static interface Entry {
        @ApiStatus.Experimental
        public Properties custom();
    }
}

