/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.utils.nbt;

import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.BinaryTagType;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.minestom.server.utils.nbt.BinaryTagUtil;
import org.jetbrains.annotations.NotNull;

public class BinaryTagReader {
    private final DataInput input;

    public BinaryTagReader(@NotNull DataInput input) {
        this.input = input;
    }

    @NotNull
    public BinaryTag readNameless() throws IOException {
        BinaryTagType<?> type = BinaryTagUtil.nbtTypeFromId(this.input.readByte());
        return type.read(this.input);
    }

    @NotNull
    public Map.Entry<String, BinaryTag> readNamed() throws IOException {
        BinaryTagType<?> type = BinaryTagUtil.nbtTypeFromId(this.input.readByte());
        String name = this.input.readUTF();
        return Map.entry(name, type.read(this.input));
    }

    static {
        BinaryTagTypes.COMPOUND.id();
    }
}

