/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.relative;

import java.util.function.Function;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.utils.location.RelativeVec;
import org.jetbrains.annotations.NotNull;

abstract class ArgumentRelativeVec
extends Argument<RelativeVec> {
    private static final char RELATIVE_CHAR = '~';
    private static final char LOCAL_CHAR = '^';
    public static final int INVALID_NUMBER_COUNT_ERROR = 1;
    public static final int INVALID_NUMBER_ERROR = 2;
    public static final int MIXED_TYPE_ERROR = 3;
    private final int numberCount;

    public ArgumentRelativeVec(@NotNull String id, int numberCount) {
        super(id, true);
        this.numberCount = numberCount;
    }

    abstract Function<String, ? extends Number> getRelativeNumberParser();

    abstract Function<String, ? extends Number> getAbsoluteNumberParser();

    @Override
    @NotNull
    public RelativeVec parse(@NotNull CommandSender sender, @NotNull String input) throws ArgumentSyntaxException {
        String[] split = input.split(" ");
        if (split.length != this.getNumberCount()) {
            throw new ArgumentSyntaxException("Invalid number of values", input, 1);
        }
        double[] coordinates = new double[split.length];
        boolean[] isRelative = new boolean[split.length];
        boolean isLocalType = false;
        for (int i = 0; i < split.length; ++i) {
            String element = split[i];
            try {
                char modifierChar = element.charAt(0);
                if (isLocalType && modifierChar != '^') {
                    throw new ArgumentSyntaxException("Cannot mix world & local coordinates (everything must either use ^ or not)", input, 3);
                }
                switch (modifierChar) {
                    case '^': {
                        isLocalType = true;
                    }
                    case '~': {
                        isRelative[i] = true;
                        if (element.length() == 1) break;
                        String potentialNumber = element.substring(1);
                        coordinates[i] = this.getRelativeNumberParser().apply(potentialNumber).doubleValue();
                        break;
                    }
                    default: {
                        coordinates[i] = this.getAbsoluteNumberParser().apply(element).doubleValue();
                    }
                }
                continue;
            }
            catch (NumberFormatException e) {
                throw new ArgumentSyntaxException("Invalid number", input, 2);
            }
        }
        boolean xRelative = isRelative[0];
        boolean yRelative = split.length == 3 && isRelative[1];
        boolean zRelative = isRelative[split.length == 3 ? 2 : 1];
        RelativeVec.CoordinateType type = isLocalType ? RelativeVec.CoordinateType.LOCAL : (xRelative || yRelative || zRelative ? RelativeVec.CoordinateType.RELATIVE : RelativeVec.CoordinateType.ABSOLUTE);
        return new RelativeVec(split.length == 3 ? new Vec(coordinates[0], coordinates[1], coordinates[2]) : new Vec(coordinates[0], coordinates[1]), type, xRelative, yRelative, zRelative);
    }

    public int getNumberCount() {
        return this.numberCount;
    }
}

