/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal.tameable;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.tameable.WolfSoundVariantImpl;
import net.minestom.server.entity.metadata.animal.tameable.WolfSoundVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.sound.SoundEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public sealed interface WolfSoundVariant
extends WolfSoundVariants
permits WolfSoundVariantImpl {
    @NotNull
    public static final NetworkBuffer.Type<RegistryKey<WolfSoundVariant>> NETWORK_TYPE = RegistryKey.networkType(Registries::wolfSoundVariant);
    @NotNull
    public static final Codec<RegistryKey<WolfSoundVariant>> CODEC = RegistryKey.codec(Registries::wolfSoundVariant);
    public static final Codec<WolfSoundVariant> REGISTRY_CODEC = StructCodec.struct("ambient_sound", SoundEvent.CODEC, WolfSoundVariant::ambientSound, "death_sound", SoundEvent.CODEC, WolfSoundVariant::deathSound, "growl_sound", SoundEvent.CODEC, WolfSoundVariant::growlSound, "hurt_sound", SoundEvent.CODEC, WolfSoundVariant::hurtSound, "pant_sound", SoundEvent.CODEC, WolfSoundVariant::pantSound, "whine_sound", SoundEvent.CODEC, WolfSoundVariant::whineSound, WolfSoundVariantImpl::new);

    @ApiStatus.Internal
    public static DynamicRegistry<WolfSoundVariant> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("minecraft:wolf_sound_variant"), REGISTRY_CODEC, RegistryData.Resource.WOLF_SOUND_VARIANTS);
    }

    @NotNull
    public static WolfSoundVariant create(@NotNull SoundEvent ambientSound, @NotNull SoundEvent deathSound, @NotNull SoundEvent growlSound, @NotNull SoundEvent hurtSound, @NotNull SoundEvent pantSound, @NotNull SoundEvent whineSound) {
        return new WolfSoundVariantImpl(ambientSound, deathSound, growlSound, hurtSound, pantSound, whineSound);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    public SoundEvent ambientSound();

    @NotNull
    public SoundEvent deathSound();

    @NotNull
    public SoundEvent growlSound();

    @NotNull
    public SoundEvent hurtSound();

    @NotNull
    public SoundEvent pantSound();

    @NotNull
    public SoundEvent whineSound();

    public static final class Builder {
        private SoundEvent ambientSound;
        private SoundEvent deathSound;
        private SoundEvent growlSound;
        private SoundEvent hurtSound;
        private SoundEvent pantSound;
        private SoundEvent whineSound;

        @NotNull
        public Builder ambientSound(@NotNull SoundEvent ambientSound) {
            this.ambientSound = ambientSound;
            return this;
        }

        @NotNull
        public Builder deathSound(@NotNull SoundEvent deathSound) {
            this.deathSound = deathSound;
            return this;
        }

        @NotNull
        public Builder growlSound(@NotNull SoundEvent growlSound) {
            this.growlSound = growlSound;
            return this;
        }

        @NotNull
        public Builder hurtSound(@NotNull SoundEvent hurtSound) {
            this.hurtSound = hurtSound;
            return this;
        }

        @NotNull
        public Builder pantSound(@NotNull SoundEvent pantSound) {
            this.pantSound = pantSound;
            return this;
        }

        @NotNull
        public Builder whineSound(@NotNull SoundEvent whineSound) {
            this.whineSound = whineSound;
            return this;
        }

        @NotNull
        public WolfSoundVariant build() {
            return new WolfSoundVariantImpl(this.ambientSound, this.deathSound, this.growlSound, this.hurtSound, this.pantSound, this.whineSound);
        }
    }
}

