/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.batch;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minestom.server.coordinate.Point;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.batch.AbsoluteBlockBatch;
import net.minestom.server.instance.batch.Batch;
import net.minestom.server.instance.batch.BatchOption;
import net.minestom.server.instance.block.Block;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativeBlockBatch
implements Batch<Runnable> {
    private final Long2ObjectMap<Block> blockIdMap = new Long2ObjectOpenHashMap<Block>();
    private final BatchOption options;
    private volatile boolean firstEntry = true;
    private int offsetX;
    private int offsetY;
    private int offsetZ;

    public RelativeBlockBatch() {
        this(new BatchOption());
    }

    public RelativeBlockBatch(BatchOption options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlock(int x, int y, int z, @NotNull Block block) {
        if (this.firstEntry) {
            this.firstEntry = false;
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
        }
        Check.argCondition(Math.abs(x -= this.offsetX) > Short.MAX_VALUE, "Relative x position may not be more than 16 bits long.");
        Check.argCondition(Math.abs(y -= this.offsetY) > Short.MAX_VALUE, "Relative y position may not be more than 16 bits long.");
        Check.argCondition(Math.abs(z -= this.offsetZ) > Short.MAX_VALUE, "Relative z position may not be more than 16 bits long.");
        long pos = Short.toUnsignedLong((short)x);
        pos = pos << 16 | Short.toUnsignedLong((short)y);
        pos = pos << 16 | Short.toUnsignedLong((short)z);
        Long2ObjectMap<Block> long2ObjectMap = this.blockIdMap;
        synchronized (long2ObjectMap) {
            this.blockIdMap.put(pos, block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Long2ObjectMap<Block> long2ObjectMap = this.blockIdMap;
        synchronized (long2ObjectMap) {
            this.blockIdMap.clear();
        }
    }

    public AbsoluteBlockBatch apply(@NotNull Instance instance, @Nullable Runnable callback) {
        return this.apply(instance, 0, 0, 0, callback);
    }

    public AbsoluteBlockBatch apply(@NotNull Instance instance, @NotNull Point position, @Nullable Runnable callback) {
        return this.apply(instance, position.blockX(), position.blockY(), position.blockZ(), callback);
    }

    public AbsoluteBlockBatch apply(@NotNull Instance instance, int x, int y, int z, @Nullable Runnable callback) {
        return this.apply(instance, x, y, z, callback, true);
    }

    public AbsoluteBlockBatch applyUnsafe(@NotNull Instance instance, int x, int y, int z, @Nullable Runnable callback) {
        return this.apply(instance, x, y, z, callback, false);
    }

    protected AbsoluteBlockBatch apply(@NotNull Instance instance, int x, int y, int z, @Nullable Runnable callback, boolean safeCallback) {
        return this.toAbsoluteBatch(x, y, z).apply(instance, callback, safeCallback);
    }

    @NotNull
    public AbsoluteBlockBatch toAbsoluteBatch() {
        return this.toAbsoluteBatch(0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AbsoluteBlockBatch toAbsoluteBatch(int x, int y, int z) {
        AbsoluteBlockBatch batch = new AbsoluteBlockBatch(this.options);
        Long2ObjectMap<Block> long2ObjectMap = this.blockIdMap;
        synchronized (long2ObjectMap) {
            for (Long2ObjectMap.Entry entry : this.blockIdMap.long2ObjectEntrySet()) {
                long pos = entry.getLongKey();
                short relZ = (short)(pos & 0xFFFFL);
                short relY = (short)(pos >> 16 & 0xFFFFL);
                short relX = (short)(pos >> 32 & 0xFFFFL);
                Block block = (Block)entry.getValue();
                int finalX = x + this.offsetX + relX;
                int finalY = y + this.offsetY + relY;
                int finalZ = z + this.offsetZ + relZ;
                batch.setBlock(finalX, finalY, finalZ, block);
            }
        }
        return batch;
    }
}

