/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.kyori.adventure.key.Key;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.block.rule.BlockPlacementRule;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlockManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockManager.class);
    private final Map<String, Supplier<BlockHandler>> blockHandlerMap = new ConcurrentHashMap<String, Supplier<BlockHandler>>();
    private final Int2ObjectMap<BlockPlacementRule> placementRuleMap = new Int2ObjectOpenHashMap<BlockPlacementRule>();
    private final Set<String> dummyWarning = ConcurrentHashMap.newKeySet();

    public void registerHandler(@NotNull String namespace, @NotNull @NotNull Supplier<@NotNull BlockHandler> handlerSupplier) {
        this.blockHandlerMap.put(namespace, handlerSupplier);
    }

    public void registerHandler(@NotNull Key key, @NotNull @NotNull Supplier<@NotNull BlockHandler> handlerSupplier) {
        this.registerHandler(key.toString(), handlerSupplier);
    }

    @Nullable
    public BlockHandler getHandler(@NotNull String namespace) {
        Supplier<BlockHandler> handler = this.blockHandlerMap.get(namespace);
        return handler != null ? handler.get() : null;
    }

    @ApiStatus.Internal
    @NotNull
    public BlockHandler getHandlerOrDummy(@NotNull String namespace) {
        BlockHandler handler = this.getHandler(namespace);
        if (handler == null) {
            if (this.dummyWarning.add(namespace)) {
                LOGGER.warn("Block {} does not have any corresponding handler, default to dummy.\nYou may want to register a handler for this namespace to prevent any data loss.", (Object)namespace);
            }
            handler = BlockHandler.Dummy.get(namespace);
        }
        return handler;
    }

    public synchronized void registerBlockPlacementRule(@NotNull BlockPlacementRule blockPlacementRule) {
        int id = blockPlacementRule.getBlock().id();
        Check.argCondition(id < 0, "Block ID must be >= 0, got: " + id);
        this.placementRuleMap.put(id, blockPlacementRule);
    }

    @Nullable
    public synchronized BlockPlacementRule getBlockPlacementRule(@NotNull Block block) {
        return (BlockPlacementRule)this.placementRuleMap.get(block.id());
    }
}

