/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.minestom.server.gamedata.DataPack;
import net.minestom.server.network.packet.server.common.TagsPacket;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.registry.RegistryKeyImpl;
import net.minestom.server.registry.RegistryTag;
import net.minestom.server.registry.RegistryTagImpl;
import net.minestom.server.registry.StaticProtocolObject;
import net.minestom.server.registry.TagKey;
import net.minestom.server.utils.collection.ObjectArray;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class StaticRegistry<T extends StaticProtocolObject<T>>
implements Registry<T> {
    private final Key key;
    private final Map<Key, T> keyToValue;
    private final Map<T, RegistryKey<T>> valueToKey;
    private final ObjectArray<T> idToValue;
    private final Map<TagKey<T>, RegistryTagImpl.Backed<T>> tags = new ConcurrentHashMap<TagKey<T>, RegistryTagImpl.Backed<T>>();

    StaticRegistry(@NotNull Key key, @NotNull Map<Key, T> namespaces, @NotNull ObjectArray<T> ids, @NotNull Map<TagKey<T>, RegistryTagImpl.Backed<T>> tags) {
        this.key = key;
        this.keyToValue = Map.copyOf(namespaces);
        HashMap valueToKey = new HashMap(namespaces.size());
        for (Map.Entry<Key, T> entry : namespaces.entrySet()) {
            valueToKey.put((StaticProtocolObject)entry.getValue(), new RegistryKeyImpl(entry.getKey()));
        }
        this.valueToKey = Map.copyOf(valueToKey);
        this.idToValue = ids;
        this.idToValue.trim();
        this.tags.putAll(tags);
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    @Nullable
    public T get(int id) {
        return (T)((StaticProtocolObject)this.idToValue.get(id));
    }

    @Override
    @Nullable
    public T get(@NotNull Key key) {
        return (T)((StaticProtocolObject)this.keyToValue.get(key));
    }

    @Override
    @Nullable
    public RegistryKey<T> getKey(int id) {
        StaticProtocolObject value = (StaticProtocolObject)this.idToValue.get(id);
        return value == null ? null : new RegistryKeyImpl(value.key());
    }

    @Override
    @Nullable
    public RegistryKey<T> getKey(@NotNull T value) {
        return this.valueToKey.get(value);
    }

    @Override
    @Nullable
    public RegistryKey<T> getKey(@NotNull Key key) {
        return this.keyToValue.containsKey(key) ? new RegistryKeyImpl(key) : null;
    }

    @Override
    public int getId(@NotNull RegistryKey<T> key) {
        StaticProtocolObject value = (StaticProtocolObject)this.keyToValue.get(key.key());
        if (value == null) {
            return -1;
        }
        return this.valueToKey.get(value) != null ? value.id() : -1;
    }

    @Override
    @Nullable
    public DataPack getPack(int id) {
        return this.idToValue.get(id) != null ? DataPack.MINECRAFT_CORE : null;
    }

    @Override
    public int size() {
        return this.keyToValue.size();
    }

    @Override
    @NotNull
    public Collection<RegistryKey<T>> keys() {
        return this.valueToKey.values();
    }

    @Override
    @NotNull
    public Collection<T> values() {
        return this.valueToKey.keySet();
    }

    @Override
    @Nullable
    public RegistryTag<T> getTag(@NotNull TagKey<T> key) {
        return this.tags.get(key);
    }

    @Override
    @NotNull
    public RegistryTag<T> getOrCreateTag(@NotNull TagKey<T> key) {
        return this.tags.computeIfAbsent(key, RegistryTagImpl.Backed::new);
    }

    @Override
    public boolean removeTag(@NotNull TagKey<T> key) {
        return this.tags.remove(key) != null;
    }

    @Override
    @NotNull
    public Collection<RegistryTag<T>> tags() {
        return Collections.unmodifiableCollection(this.tags.values());
    }

    @Override
    public @NotNull TagsPacket.Registry tagRegistry() {
        ArrayList<TagsPacket.Tag> tagList = new ArrayList<TagsPacket.Tag>(this.tags.size());
        for (RegistryTagImpl.Backed<T> tag : this.tags.values()) {
            int[] entries = new int[tag.size()];
            int i = 0;
            for (RegistryKey<T> staticEntry : tag) {
                int n;
                int n2 = i++;
                if (staticEntry instanceof StaticProtocolObject) {
                    StaticProtocolObject po = (StaticProtocolObject)staticEntry;
                    n = po.id();
                } else {
                    n = this.getId(staticEntry);
                }
                entries[n2] = n;
            }
            tagList.add(new TagsPacket.Tag(tag.key().key().asString(), entries));
        }
        return new TagsPacket.Registry(this.key().asString(), tagList);
    }
}

