/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.sound;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.sound.Sound;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.sound.BuiltinSoundEvent;
import net.minestom.server.sound.CustomSoundEvent;
import net.minestom.server.sound.SoundEvents;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface SoundEvent
extends Keyed,
Sound.Type,
SoundEvents
permits BuiltinSoundEvent, CustomSoundEvent {
    @NotNull
    public static final NetworkBuffer.Type<SoundEvent> NETWORK_TYPE = new NetworkBuffer.Type<SoundEvent>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, SoundEvent value) {
            SoundEvent soundEvent = value;
            Objects.requireNonNull(soundEvent);
            SoundEvent soundEvent2 = soundEvent;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BuiltinSoundEvent.class, CustomSoundEvent.class}, (Object)soundEvent2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    BuiltinSoundEvent soundEvent3 = (BuiltinSoundEvent)soundEvent2;
                    buffer.write(NetworkBuffer.VAR_INT, soundEvent3.id() + 1);
                    break;
                }
                case 1: {
                    CustomSoundEvent soundEvent4 = (CustomSoundEvent)soundEvent2;
                    buffer.write(NetworkBuffer.VAR_INT, 0);
                    buffer.write(NetworkBuffer.STRING, soundEvent4.name());
                    buffer.write(NetworkBuffer.FLOAT.optional(), soundEvent4.range());
                }
            }
        }

        @Override
        public SoundEvent read(@NotNull NetworkBuffer buffer) {
            int id = buffer.read(NetworkBuffer.VAR_INT) - 1;
            if (id != -1) {
                return BuiltinSoundEvent.REGISTRY.get(id);
            }
            return new CustomSoundEvent(buffer.read(NetworkBuffer.KEY), buffer.read(NetworkBuffer.FLOAT.optional()));
        }
    };
    @NotNull
    public static final Codec<SoundEvent> CODEC = new Codec<SoundEvent>(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        @NotNull
        public <D> Result<SoundEvent> decode(@NotNull Transcoder<D> coder, @NotNull D value) {
            Result<String> stringResult = coder.getString(value);
            if (stringResult instanceof Result.Ok) {
                String string;
                Result.Ok ok = (Result.Ok)stringResult;
                String string2 = string = (String)ok.value();
                SoundEvent soundEvent = BuiltinSoundEvent.get(string2);
                if (soundEvent != null) return new Result.Ok<SoundEvent>(soundEvent);
                return new Result.Error<SoundEvent>("Unknown sound event: " + string2);
            }
            Result customResult = CustomSoundEvent.CODEC.decode(coder, value);
            if (!(customResult instanceof Result.Ok)) return customResult.cast();
            Result.Ok ok = (Result.Ok)customResult;
            try {
                CustomSoundEvent customSoundEvent;
                CustomSoundEvent customSoundEvent2 = customSoundEvent = (CustomSoundEvent)ok.value();
                return new Result.Ok<SoundEvent>(customSoundEvent2);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }

        @Override
        @NotNull
        public <D> Result<D> encode(@NotNull Transcoder<D> coder, @Nullable SoundEvent value) {
            if (value == null) {
                return new Result.Error("null");
            }
            SoundEvent soundEvent = value;
            Objects.requireNonNull(soundEvent);
            SoundEvent soundEvent2 = soundEvent;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BuiltinSoundEvent.class, CustomSoundEvent.class}, (Object)soundEvent2, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    BuiltinSoundEvent soundEvent = (BuiltinSoundEvent)soundEvent2;
                    yield new Result.Ok<D>(coder.createString(soundEvent.name()));
                }
                case 1 -> {
                    CustomSoundEvent soundEvent = (CustomSoundEvent)soundEvent2;
                    yield CustomSoundEvent.CODEC.encode(coder, soundEvent);
                }
            };
        }
    };

    @NotNull
    public static Collection<? extends SoundEvent> values() {
        return BuiltinSoundEvent.REGISTRY.values();
    }

    @Nullable
    public static SoundEvent fromKey(@KeyPattern @NotNull String key) {
        return SoundEvent.fromKey(Key.key(key));
    }

    @Nullable
    public static SoundEvent fromKey(@NotNull Key key) {
        return BuiltinSoundEvent.REGISTRY.get(key);
    }

    @Nullable
    public static SoundEvent fromId(int id) {
        return BuiltinSoundEvent.REGISTRY.get(id);
    }

    @NotNull
    public static SoundEvent of(@NotNull String key, @Nullable Float range) {
        return new CustomSoundEvent(Key.key(key), range);
    }

    @NotNull
    public static SoundEvent of(@NotNull Key key, @Nullable Float range) {
        return new CustomSoundEvent(key, range);
    }

    @Contract(pure=true)
    @NotNull
    default public String name() {
        return this.key().asString();
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Key key();
}

