/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32C;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.NotNull;

final class TranscoderCrc32Impl
implements Transcoder<Integer> {
    static final TranscoderCrc32Impl INSTANCE = new TranscoderCrc32Impl();
    private static final Comparator<Map.Entry<Integer, Integer>> KEY_COMPARATOR = Map.Entry.comparingByKey(Comparator.comparingLong(Integer::toUnsignedLong));
    private static final Comparator<Map.Entry<Integer, Integer>> VALUE_COMPARATOR = Map.Entry.comparingByValue(Comparator.comparingLong(Integer::toUnsignedLong));
    private static final Comparator<Map.Entry<Integer, Integer>> MAP_COMPARATOR = KEY_COMPARATOR.thenComparing(VALUE_COMPARATOR);
    private static final byte TAG_EMPTY = 1;
    private static final byte TAG_MAP_START = 2;
    private static final byte TAG_MAP_END = 3;
    private static final byte TAG_LIST_START = 4;
    private static final byte TAG_LIST_END = 5;
    private static final byte TAG_BYTE = 6;
    private static final byte TAG_SHORT = 7;
    private static final byte TAG_INT = 8;
    private static final byte TAG_LONG = 9;
    private static final byte TAG_FLOAT = 10;
    private static final byte TAG_DOUBLE = 11;
    private static final byte TAG_STRING = 12;
    private static final byte TAG_BOOLEAN = 13;
    private static final byte TAG_BYTE_ARRAY_START = 14;
    private static final byte TAG_BYTE_ARRAY_END = 15;
    private static final byte TAG_INT_ARRAY_START = 16;
    private static final byte TAG_INT_ARRAY_END = 17;
    private static final byte TAG_LONG_ARRAY_START = 18;
    private static final byte TAG_LONG_ARRAY_END = 19;
    private static final int EMPTY = new Hasher().putByte((byte)1).hash();
    private static final int EMPTY_MAP = new Hasher().putByte((byte)2).putByte((byte)3).hash();
    private static final int EMPTY_LIST = new Hasher().putByte((byte)4).putByte((byte)5).hash();
    private static final int FALSE = new Hasher().putByte((byte)13).putByte((byte)0).hash();
    private static final int TRUE = new Hasher().putByte((byte)13).putByte((byte)1).hash();

    TranscoderCrc32Impl() {
    }

    @Override
    @NotNull
    public Integer createNull() {
        return EMPTY;
    }

    @Override
    @NotNull
    public Integer createBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    @Override
    @NotNull
    public Integer createByte(byte value) {
        return new Hasher().putByte((byte)6).putByte(value).hash();
    }

    @Override
    @NotNull
    public Integer createShort(short value) {
        return new Hasher().putByte((byte)7).putShort(value).hash();
    }

    @Override
    @NotNull
    public Integer createInt(int value) {
        return new Hasher().putByte((byte)8).putInt(value).hash();
    }

    @Override
    @NotNull
    public Integer createLong(long value) {
        return new Hasher().putByte((byte)9).putLong(value).hash();
    }

    @Override
    @NotNull
    public Integer createFloat(float value) {
        return new Hasher().putByte((byte)10).putFloat(value).hash();
    }

    @Override
    @NotNull
    public Integer createDouble(double value) {
        return new Hasher().putByte((byte)11).putDouble(value).hash();
    }

    @Override
    @NotNull
    public Integer createString(@NotNull String value) {
        return new Hasher().putByte((byte)12).putInt(value.length()).putChars(value).hash();
    }

    @Override
    @NotNull
    public Integer emptyList() {
        return EMPTY_LIST;
    }

    @Override
    @NotNull
    public Transcoder.ListBuilder<Integer> createList(int expectedSize) {
        final Hasher hasher = new Hasher().putByte((byte)4);
        return new Transcoder.ListBuilder<Integer>(this){

            @Override
            @NotNull
            public Transcoder.ListBuilder<Integer> add(Integer value) {
                hasher.putIntBytes(value);
                return this;
            }

            @Override
            public Integer build() {
                return hasher.putByte((byte)5).hash();
            }
        };
    }

    @Override
    @NotNull
    public Integer emptyMap() {
        return EMPTY_MAP;
    }

    @Override
    @NotNull
    public Transcoder.MapBuilder<Integer> createMap() {
        final HashMap map = new HashMap();
        return new Transcoder.MapBuilder<Integer>(){

            @Override
            @NotNull
            public Transcoder.MapBuilder<Integer> put(@NotNull Integer key, Integer value) {
                if (value != EMPTY) {
                    map.put(key, value);
                }
                return this;
            }

            @Override
            @NotNull
            public Transcoder.MapBuilder<Integer> put(@NotNull String key, Integer value) {
                return this.put(TranscoderCrc32Impl.this.createString(key), value);
            }

            @Override
            public Integer build() {
                if (map.isEmpty()) {
                    return EMPTY_MAP;
                }
                Hasher hasher = new Hasher().putByte((byte)2);
                map.entrySet().stream().sorted(MAP_COMPARATOR).forEach(entry -> {
                    hasher.putIntBytes((Integer)entry.getKey());
                    hasher.putIntBytes((Integer)entry.getValue());
                });
                return hasher.putByte((byte)3).hash();
            }
        };
    }

    @Override
    @NotNull
    public Integer createByteArray(byte[] value) {
        return new Hasher().putByte((byte)14).putBytes(value).putByte((byte)15).hash();
    }

    @Override
    @NotNull
    public Integer createIntArray(int[] value) {
        Hasher hasher = new Hasher().putByte((byte)16);
        for (int item : value) {
            hasher.putInt(item);
        }
        return hasher.putByte((byte)17).hash();
    }

    @Override
    @NotNull
    public Integer createLongArray(long[] value) {
        Hasher hasher = new Hasher().putByte((byte)18);
        for (long item : value) {
            hasher.putLong(item);
        }
        return hasher.putByte((byte)19).hash();
    }

    @Override
    @NotNull
    public Result<Boolean> getBoolean(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<Byte> getByte(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<Short> getShort(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<Integer> getInt(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<Long> getLong(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<Float> getFloat(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<Double> getDouble(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<String> getString(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<byte[]> getByteArray(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<int[]> getIntArray(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<long[]> getLongArray(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<List<Integer>> getList(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public Result<Transcoder.MapLike<Integer>> getMap(@NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @Override
    @NotNull
    public <O> Result<O> convertTo(@NotNull Transcoder<O> coder, @NotNull Integer value) {
        return TranscoderCrc32Impl.writeOnly();
    }

    @NotNull
    private static <T> Result<T> writeOnly() {
        return new Result.Error("CRC32 transcoder only supports encoding");
    }

    private record Hasher(@NotNull CRC32C crc32, @NotNull ByteBuffer buffer) {
        public Hasher() {
            this(new CRC32C(), ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN));
        }

        @NotNull
        private Hasher update(int bytes) {
            this.crc32.update(this.buffer.array(), 0, bytes);
            this.buffer.position(0);
            return this;
        }

        @NotNull
        public Hasher putByte(byte b) {
            this.crc32.update(b);
            return this;
        }

        @NotNull
        public Hasher putShort(short s) {
            this.buffer.putShort(s);
            return this.update(2);
        }

        @NotNull
        public Hasher putInt(int i) {
            this.buffer.putInt(i);
            return this.update(4);
        }

        @NotNull
        public Hasher putIntBytes(int i) {
            this.putByte((byte)i);
            this.putByte((byte)(i >> 8));
            this.putByte((byte)(i >> 16));
            this.putByte((byte)(i >> 24));
            return this;
        }

        @NotNull
        public Hasher putLong(long l) {
            this.buffer.putLong(l);
            return this.update(8);
        }

        @NotNull
        public Hasher putFloat(float f) {
            return this.putInt(Float.floatToRawIntBits(f));
        }

        @NotNull
        public Hasher putDouble(double d) {
            return this.putLong(Double.doubleToRawLongBits(d));
        }

        @NotNull
        public Hasher putChar(char c) {
            this.putByte((byte)c);
            this.putByte((byte)(c >>> 8));
            return this;
        }

        @NotNull
        public Hasher putChars(@NotNull String string) {
            for (int i = 0; i < string.length(); ++i) {
                this.putChar(string.charAt(i));
            }
            return this;
        }

        @NotNull
        public Hasher putBytes(byte[] bytes) {
            this.crc32.update(bytes);
            return this;
        }

        public int hash() {
            return (int)this.crc32.getValue();
        }
    }
}

