/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum ArgumentParserType implements StaticProtocolObject<ArgumentParserType>
{
    BOOL(Key.key("brigadier:bool")),
    FLOAT(Key.key("brigadier:float")),
    DOUBLE(Key.key("brigadier:double")),
    INTEGER(Key.key("brigadier:integer")),
    LONG(Key.key("brigadier:long")),
    STRING(Key.key("brigadier:string")),
    ENTITY(Key.key("minecraft:entity")),
    GAME_PROFILE(Key.key("minecraft:game_profile")),
    BLOCK_POS(Key.key("minecraft:block_pos")),
    COLUMN_POS(Key.key("minecraft:column_pos")),
    VEC3(Key.key("minecraft:vec3")),
    VEC2(Key.key("minecraft:vec2")),
    BLOCK_STATE(Key.key("minecraft:block_state")),
    BLOCK_PREDICATE(Key.key("minecraft:block_predicate")),
    ITEM_STACK(Key.key("minecraft:item_stack")),
    ITEM_PREDICATE(Key.key("minecraft:item_predicate")),
    COLOR(Key.key("minecraft:color")),
    HEX_COLOR(Key.key("minecraft:hex_color")),
    COMPONENT(Key.key("minecraft:component")),
    STYLE(Key.key("minecraft:style")),
    MESSAGE(Key.key("minecraft:message")),
    NBT_COMPOUND_TAG(Key.key("minecraft:nbt_compound_tag")),
    NBT_TAG(Key.key("minecraft:nbt_tag")),
    NBT_PATH(Key.key("minecraft:nbt_path")),
    OBJECTIVE(Key.key("minecraft:objective")),
    OBJECTIVE_CRITERIA(Key.key("minecraft:objective_criteria")),
    OPERATION(Key.key("minecraft:operation")),
    PARTICLE(Key.key("minecraft:particle")),
    ANGLE(Key.key("minecraft:angle")),
    ROTATION(Key.key("minecraft:rotation")),
    SCOREBOARD_SLOT(Key.key("minecraft:scoreboard_slot")),
    SCORE_HOLDER(Key.key("minecraft:score_holder")),
    SWIZZLE(Key.key("minecraft:swizzle")),
    TEAM(Key.key("minecraft:team")),
    ITEM_SLOT(Key.key("minecraft:item_slot")),
    ITEM_SLOTS(Key.key("minecraft:item_slots")),
    RESOURCE_LOCATION(Key.key("minecraft:resource_location")),
    FUNCTION(Key.key("minecraft:function")),
    ENTITY_ANCHOR(Key.key("minecraft:entity_anchor")),
    INT_RANGE(Key.key("minecraft:int_range")),
    FLOAT_RANGE(Key.key("minecraft:float_range")),
    DIMENSION(Key.key("minecraft:dimension")),
    GAMEMODE(Key.key("minecraft:gamemode")),
    TIME(Key.key("minecraft:time")),
    RESOURCE_OR_TAG(Key.key("minecraft:resource_or_tag")),
    RESOURCE_OR_TAG_KEY(Key.key("minecraft:resource_or_tag_key")),
    RESOURCE(Key.key("minecraft:resource")),
    RESOURCE_KEY(Key.key("minecraft:resource_key")),
    RESOURCE_SELECTOR(Key.key("minecraft:resource_selector")),
    TEMPLATE_MIRROR(Key.key("minecraft:template_mirror")),
    TEMPLATE_ROTATION(Key.key("minecraft:template_rotation")),
    HEIGHTMAP(Key.key("minecraft:heightmap")),
    LOOT_TABLE(Key.key("minecraft:loot_table")),
    LOOT_PREDICATE(Key.key("minecraft:loot_predicate")),
    LOOT_MODIFIER(Key.key("minecraft:loot_modifier")),
    DIALOG(Key.key("minecraft:dialog")),
    UUID(Key.key("minecraft:uuid"));

    private static final Map<Key, ArgumentParserType> BY_KEY;
    public static final NetworkBuffer.Type<ArgumentParserType> NETWORK_TYPE;
    public static final Codec<ArgumentParserType> CODEC;
    private final Key key;

    private ArgumentParserType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(ArgumentParserType.values()).collect(Collectors.toMap(ArgumentParserType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(ArgumentParserType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, ArgumentParserType::key);
    }
}

