/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minestom.server.command.CommandParser;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.ExecutableCommand;
import net.minestom.server.command.Graph;
import net.minestom.server.command.builder.ArgumentCallback;
import net.minestom.server.command.builder.CommandContext;
import net.minestom.server.command.builder.CommandData;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.condition.CommandCondition;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.command.builder.suggestion.Suggestion;
import net.minestom.server.command.builder.suggestion.SuggestionCallback;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CommandParserImpl
implements CommandParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandParserImpl.class);
    static final CommandParserImpl PARSER = new CommandParserImpl();

    CommandParserImpl() {
    }

    @Override
    @NotNull
    public CommandParser.Result parse(@NotNull CommandSender sender, @NotNull Graph graph, @NotNull String input) {
        CommandExecutor executor;
        CommandStringReader reader = new CommandStringReader(input);
        Chain chain = new Chain();
        Graph.Node parent = graph.root();
        NodeResult result = CommandParserImpl.parseNode(sender, parent, chain, reader);
        chain = result.chain;
        NodeResult lastNodeResult = chain.nodeResults.peekLast();
        if (lastNodeResult == null) {
            return UnknownCommandResult.INSTANCE;
        }
        Graph.Node lastNode = lastNodeResult.node;
        if (result.argumentResult instanceof ArgumentResult.Success && (executor = CommandParserImpl.nullSafeGetter(lastNode.execution(), Graph.Execution::executor)) != null) {
            return ValidCommand.executor(input, chain, executor);
        }
        if (lastNode.equals(parent)) {
            return UnknownCommandResult.INSTANCE;
        }
        if (chain.defaultExecutor != null) {
            return ValidCommand.defaultExecutor(input, chain);
        }
        return InvalidCommand.invalid(input, chain);
    }

    @Contract(value="null, _ -> null; !null, null -> fail; !null, !null -> _")
    @Nullable
    private static <R, T> R nullSafeGetter(@Nullable T obj, Function<T, R> getter) {
        return obj == null ? null : (R)getter.apply(obj);
    }

    private static NodeResult parseNode(@NotNull CommandSender sender, Graph.Node node, Chain chain, CommandStringReader reader) {
        chain = chain.fork();
        Argument<?> argument = node.argument();
        int start = reader.cursor();
        if (reader.hasRemaining()) {
            SuggestionCallback suggestionCallback = argument.getSuggestionCallback();
            ArgumentResult<Object> result = CommandParserImpl.parseArgument(sender, argument, reader);
            NodeResult nodeResult = new NodeResult(node, chain, result, suggestionCallback);
            chain.append(nodeResult);
            if (suggestionCallback != null) {
                chain.suggestionCallback = suggestionCallback;
            }
            if (chain.size() == 1) {
                reader.cursor(start);
            } else if (!(result instanceof ArgumentResult.Success)) {
                reader.cursor(start);
                return nodeResult;
            }
        } else {
            Function<CommandSender, ?> defaultSupplier = node.argument().getDefaultValue();
            if (defaultSupplier != null) {
                Object value = defaultSupplier.apply(sender);
                ArgumentResult.Success<Object> argumentResult = new ArgumentResult.Success<Object>(value, "");
                chain.append(new NodeResult(node, chain, argumentResult, argument.getSuggestionCallback()));
            } else {
                return new NodeResult(node, chain, new ArgumentResult.SyntaxError<Object>("Not enough arguments", "", -1), argument.getSuggestionCallback());
            }
        }
        start = reader.cursor();
        if (!reader.hasRemaining()) {
            --start;
        }
        NodeResult error = null;
        for (Graph.Node child : node.next()) {
            NodeResult childResult = CommandParserImpl.parseNode(sender, child, chain, reader);
            if (childResult.argumentResult instanceof ArgumentResult.Success) {
                return childResult;
            }
            if (!(error != null && error.chain.size() >= childResult.chain.size() || childResult.chain.size() == 2 && childResult.argumentResult instanceof ArgumentResult.IncompatibleType)) {
                error = childResult;
            }
            reader.cursor(start);
        }
        CommandExecutor executor = CommandParserImpl.nullSafeGetter(node.execution(), Graph.Execution::executor);
        if (executor == null) {
            if (error != null) {
                return error;
            }
            return chain.nodeResults.peekLast();
        }
        if (reader.hasRemaining()) {
            Graph.Node returnNode = node;
            SuggestionCallback suggestionCallback = argument.getSuggestionCallback();
            List<Graph.Node> nextNodes = node.next();
            if (!nextNodes.isEmpty()) {
                returnNode = nextNodes.getFirst();
                suggestionCallback = returnNode.argument().getSuggestionCallback();
            }
            NodeResult nodeResult = new NodeResult(returnNode, chain, new ArgumentResult.SyntaxError<Object>("Command has trailing data", "", -1), suggestionCallback);
            chain.suggestionCallback = suggestionCallback;
            if (chain.getArgs().stream().noneMatch(arg -> arg.getId().equals(argument.getId()))) {
                chain.append(nodeResult);
            }
            return nodeResult;
        }
        return chain.nodeResults.peekLast();
    }

    private static CommandContext createCommandContext(String input, Map<String, ArgumentResult<Object>> arguments) {
        CommandContext context = new CommandContext(input);
        for (Map.Entry<String, ArgumentResult<Object>> entry : arguments.entrySet()) {
            String string;
            Object argOutput;
            String identifier = entry.getKey();
            ArgumentResult<Object> value = entry.getValue();
            if (value instanceof ArgumentResult.Success) {
                ArgumentResult.Success success = (ArgumentResult.Success)value;
                v0 = success.value();
            } else {
                v0 = argOutput = null;
            }
            if (value instanceof ArgumentResult.Success) {
                ArgumentResult.Success success = (ArgumentResult.Success)value;
                string = success.input();
            } else {
                string = "";
            }
            String argInput = string;
            context.setArg(identifier, argOutput, argInput);
        }
        return context;
    }

    private static <T> ArgumentResult<T> parseArgument(@NotNull CommandSender sender, Argument<T> argument, CommandStringReader reader) {
        try {
            if (!argument.allowSpace()) {
                String word = reader.readWord();
                return new ArgumentResult.Success<T>(argument.parse(sender, word), word);
            }
            if (argument.useRemaining()) {
                String remaining = reader.readRemaining();
                return new ArgumentResult.Success<T>(argument.parse(sender, remaining), remaining);
            }
        }
        catch (ArgumentSyntaxException ignored) {
            return new ArgumentResult.IncompatibleType();
        }
        assert (argument.allowSpace() && !argument.useRemaining());
        StringBuilder current = new StringBuilder(reader.readWord());
        while (true) {
            try {
                String input = current.toString();
                return new ArgumentResult.Success<T>(argument.parse(sender, input), input);
            }
            catch (ArgumentSyntaxException ignored) {
                if (reader.hasRemaining()) {
                    current.append(" ");
                    current.append(reader.readWord());
                    continue;
                }
                return new ArgumentResult.IncompatibleType();
            }
            break;
        }
    }

    static final class CommandStringReader {
        private final String input;
        private int cursor = 0;

        CommandStringReader(String input) {
            this.input = input;
        }

        boolean hasRemaining() {
            return this.cursor < this.input.length();
        }

        String readWord() {
            String input = this.input;
            int cursor = this.cursor;
            int i = input.indexOf(32, cursor);
            if (i == -1) {
                this.cursor = input.length() + 1;
                return input.substring(cursor);
            }
            String read = input.substring(cursor, i);
            this.cursor += read.length() + 1;
            return read;
        }

        String readRemaining() {
            String input = this.input;
            String result = input.substring(this.cursor);
            this.cursor = input.length();
            return result;
        }

        int cursor() {
            return this.cursor;
        }

        void cursor(int cursor) {
            assert (cursor >= 0 && cursor <= this.input.length());
            this.cursor = cursor;
        }
    }

    static final class Chain {
        CommandExecutor defaultExecutor = null;
        SuggestionCallback suggestionCallback = null;
        final ArrayDeque<NodeResult> nodeResults = new ArrayDeque();
        final List<CommandCondition> conditions = new ArrayList<CommandCondition>();
        final List<CommandExecutor> globalListeners = new ArrayList<CommandExecutor>();

        void append(NodeResult result) {
            this.nodeResults.add(result);
            Graph.Execution execution = result.node.execution();
            if (execution != null) {
                CommandExecutor globalListener;
                CommandExecutor defExec;
                CommandCondition condition = execution.condition();
                if (condition != null) {
                    this.conditions.add(condition);
                }
                if ((defExec = execution.defaultExecutor()) != null) {
                    this.defaultExecutor = defExec;
                }
                if ((globalListener = execution.globalListener()) != null) {
                    this.globalListeners.add(globalListener);
                }
            }
        }

        CommandCondition mergedConditions() {
            return (sender, commandString) -> {
                for (CommandCondition condition : this.conditions) {
                    if (condition.canUse(sender, commandString)) continue;
                    return false;
                }
                return true;
            };
        }

        CommandExecutor mergedGlobalExecutors() {
            return (sender, context) -> this.globalListeners.forEach(x -> x.apply(sender, context));
        }

        Map<String, ArgumentResult<Object>> collectArguments() {
            return this.nodeResults.stream().skip(2L).collect(Collectors.toUnmodifiableMap(NodeResult::name, NodeResult::argumentResult));
        }

        List<Argument<?>> getArgs() {
            return this.nodeResults.stream().map(x -> x.node.argument()).collect(Collectors.toList());
        }

        int size() {
            return this.nodeResults.size();
        }

        Chain() {
        }

        Chain(CommandExecutor defaultExecutor, SuggestionCallback suggestionCallback, ArrayDeque<NodeResult> nodeResults, List<CommandCondition> conditions, List<CommandExecutor> globalListeners) {
            this.defaultExecutor = defaultExecutor;
            this.suggestionCallback = suggestionCallback;
            this.nodeResults.addAll(nodeResults);
            this.conditions.addAll(conditions);
            this.globalListeners.addAll(globalListeners);
        }

        Chain fork() {
            return new Chain(this.defaultExecutor, this.suggestionCallback, this.nodeResults, this.conditions, this.globalListeners);
        }
    }

    private record NodeResult(Graph.Node node, Chain chain, ArgumentResult<Object> argumentResult, SuggestionCallback callback) {
        public String name() {
            return this.node.argument().getId();
        }
    }

    record UnknownCommandResult() implements CommandParser.Result.UnknownCommand
    {
        private static final CommandParser.Result INSTANCE = new UnknownCommandResult();

        @Override
        @NotNull
        public ExecutableCommand executable() {
            return UnknownExecutableCmd.INSTANCE;
        }

        @Override
        @Nullable
        public Suggestion suggestion(CommandSender sender) {
            return null;
        }

        @Override
        public List<Argument<?>> args() {
            return null;
        }
    }

    private static sealed interface ArgumentResult<R> {

        public record SyntaxError<T>(String message, String input, int code) implements ArgumentResult<T>
        {
        }

        public record IncompatibleType<T>() implements ArgumentResult<T>
        {
        }

        public record Success<T>(T value, String input) implements ArgumentResult<T>
        {
        }
    }

    record ValidCommand(String input, CommandCondition condition, CommandExecutor executor, @NotNull Map<String, ArgumentResult<Object>> arguments, CommandExecutor globalListener, @Nullable SuggestionCallback suggestionCallback, List<Argument<?>> args) implements InternalKnownCommand,
    CommandParser.Result.KnownCommand.Valid
    {
        static ValidCommand defaultExecutor(String input, Chain chain) {
            return new ValidCommand(input, chain.mergedConditions(), chain.defaultExecutor, chain.collectArguments(), chain.mergedGlobalExecutors(), chain.suggestionCallback, chain.getArgs());
        }

        static ValidCommand executor(String input, Chain chain, CommandExecutor executor) {
            return new ValidCommand(input, chain.mergedConditions(), executor, chain.collectArguments(), chain.mergedGlobalExecutors(), chain.suggestionCallback, chain.getArgs());
        }

        @Override
        @NotNull
        public ExecutableCommand executable() {
            return new ValidExecutableCmd(this.condition, this.globalListener, this.executor, this.input, this.arguments);
        }
    }

    record InvalidCommand(String input, CommandCondition condition, ArgumentCallback callback, ArgumentResult.SyntaxError<?> error, @NotNull Map<String, ArgumentResult<Object>> arguments, CommandExecutor globalListener, @Nullable SuggestionCallback suggestionCallback, List<Argument<?>> args) implements InternalKnownCommand,
    CommandParser.Result.KnownCommand.Invalid
    {
        static InvalidCommand invalid(String input, Chain chain) {
            return new InvalidCommand(input, chain.mergedConditions(), null, new ArgumentResult.SyntaxError("Command has trailing data.", null, -1), chain.collectArguments(), chain.mergedGlobalExecutors(), chain.suggestionCallback, chain.getArgs());
        }

        @Override
        @NotNull
        public ExecutableCommand executable() {
            return new InvalidExecutableCmd(this.condition, this.globalListener, this.callback, this.error, this.input, this.arguments);
        }
    }

    record ExecutionResultImpl(ExecutableCommand.Result.Type type, CommandData commandData) implements ExecutableCommand.Result
    {
        static final ExecutableCommand.Result CANCELLED = new ExecutionResultImpl(ExecutableCommand.Result.Type.CANCELLED, null);
        static final ExecutableCommand.Result UNKNOWN = new ExecutionResultImpl(ExecutableCommand.Result.Type.UNKNOWN, null);
        static final ExecutableCommand.Result EXECUTOR_EXCEPTION = new ExecutionResultImpl(ExecutableCommand.Result.Type.EXECUTOR_EXCEPTION, null);
        static final ExecutableCommand.Result PRECONDITION_FAILED = new ExecutionResultImpl(ExecutableCommand.Result.Type.PRECONDITION_FAILED, null);
        static final ExecutableCommand.Result INVALID_SYNTAX = new ExecutionResultImpl(ExecutableCommand.Result.Type.INVALID_SYNTAX, null);
    }

    record InvalidExecutableCmd(CommandCondition condition, CommandExecutor globalListener, ArgumentCallback callback, ArgumentResult.SyntaxError<?> error, String input, Map<String, ArgumentResult<Object>> arguments) implements ExecutableCommand
    {
        @Override
        @NotNull
        public ExecutableCommand.Result execute(@NotNull CommandSender sender) {
            this.globalListener().apply(sender, CommandParserImpl.createCommandContext(this.input, this.arguments));
            if (this.condition != null && !this.condition.canUse(sender, this.input())) {
                return ExecutionResultImpl.PRECONDITION_FAILED;
            }
            if (this.callback != null) {
                this.callback.apply(sender, new ArgumentSyntaxException(this.error.message(), this.error.input(), this.error.code()));
            }
            return ExecutionResultImpl.INVALID_SYNTAX;
        }
    }

    record ValidExecutableCmd(CommandCondition condition, CommandExecutor globalListener, CommandExecutor executor, String input, Map<String, ArgumentResult<Object>> arguments) implements ExecutableCommand
    {
        @Override
        @NotNull
        public ExecutableCommand.Result execute(@NotNull CommandSender sender) {
            CommandContext context = CommandParserImpl.createCommandContext(this.input, this.arguments);
            this.globalListener().apply(sender, context);
            if (this.condition != null && !this.condition.canUse(sender, this.input())) {
                return ExecutionResultImpl.PRECONDITION_FAILED;
            }
            try {
                this.executor().apply(sender, context);
                return new ExecutionResultImpl(ExecutableCommand.Result.Type.SUCCESS, context.getReturnData());
            }
            catch (Exception e) {
                LOGGER.error("An exception was encountered while executing command: " + this.input(), e);
                return ExecutionResultImpl.EXECUTOR_EXCEPTION;
            }
        }
    }

    record UnknownExecutableCmd() implements ExecutableCommand
    {
        static final ExecutableCommand INSTANCE = new UnknownExecutableCmd();

        @Override
        @NotNull
        public ExecutableCommand.Result execute(@NotNull CommandSender sender) {
            return ExecutionResultImpl.UNKNOWN;
        }
    }

    static sealed interface InternalKnownCommand
    extends CommandParser.Result.KnownCommand
    permits InvalidCommand, ValidCommand {
        public String input();

        @Nullable
        public CommandCondition condition();

        @NotNull
        public Map<String, ArgumentResult<Object>> arguments();

        public CommandExecutor globalListener();

        @Nullable
        public SuggestionCallback suggestionCallback();

        @Override
        @Nullable
        default public Suggestion suggestion(CommandSender sender) {
            SuggestionCallback callback = this.suggestionCallback();
            if (callback == null) {
                return null;
            }
            int lastSpace = this.input().lastIndexOf(" ");
            Suggestion suggestion = new Suggestion(this.input(), lastSpace + 2, this.input().length() - lastSpace - 1);
            CommandContext context = CommandParserImpl.createCommandContext(this.input(), this.arguments());
            callback.apply(sender, context, suggestion);
            return suggestion;
        }
    }
}

