/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.other;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.other.PaintingVariantImpl;
import net.minestom.server.entity.metadata.other.PaintingVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public sealed interface PaintingVariant
extends Holder.Direct<PaintingVariant>,
PaintingVariants
permits PaintingVariantImpl {
    @NotNull
    public static final NetworkBuffer.Type<PaintingVariant> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.KEY, PaintingVariant::assetId, NetworkBuffer.INT, PaintingVariant::width, NetworkBuffer.INT, PaintingVariant::height, NetworkBuffer.COMPONENT.optional(), PaintingVariant::title, NetworkBuffer.COMPONENT.optional(), PaintingVariant::author, PaintingVariant::create);
    @NotNull
    public static final Codec<PaintingVariant> REGISTRY_CODEC = StructCodec.struct("asset_id", Codec.KEY, PaintingVariant::assetId, "width", Codec.INT, PaintingVariant::width, "height", Codec.INT, PaintingVariant::height, "title", Codec.COMPONENT.optional(), PaintingVariant::title, "author", Codec.COMPONENT.optional(), PaintingVariant::author, PaintingVariant::create);
    @NotNull
    public static final NetworkBuffer.Type<Holder<PaintingVariant>> NETWORK_TYPE = Holder.networkType(Registries::paintingVariant, REGISTRY_NETWORK_TYPE);
    @NotNull
    public static final Codec<Holder<PaintingVariant>> CODEC = RegistryKey.codec(Registries::paintingVariant).transform(key -> key, Holder::asKey);

    @NotNull
    public static PaintingVariant create(@NotNull Key assetId, int width, int height, @Nullable Component title, @Nullable Component author) {
        return new PaintingVariantImpl(assetId, width, height, title, author);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<PaintingVariant> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("minecraft:painting_variant"), REGISTRY_CODEC, RegistryData.Resource.PAINTING_VARIANTS);
    }

    @NotNull
    public Key assetId();

    public int width();

    public int height();

    @Nullable
    public Component title();

    @Nullable
    public Component author();

    public static class Builder {
        private Key assetId;
        private int width;
        private int height;
        private Component title;
        private Component author;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetId(@NotNull Key assetId) {
            this.assetId = assetId;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder width(int width) {
            this.width = width;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder height(int height) {
            this.height = height;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder title(@Nullable Component title) {
            this.title = title;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder author(@Nullable Component author) {
            this.author = author;
            return this;
        }

        @NotNull
        public PaintingVariant build() {
            return new PaintingVariantImpl(this.assetId, this.width, this.height, this.title, this.author);
        }
    }
}

