/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.villager;

import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.VillagerProfession;
import net.minestom.server.entity.VillagerType;
import net.minestom.server.entity.metadata.villager.AbstractVillagerMeta;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerMeta
extends AbstractVillagerMeta {
    public VillagerMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public VillagerData getVillagerData() {
        return this.metadata.get(MetadataDef.Villager.VARIANT);
    }

    public void setVillagerData(@NotNull VillagerData data) {
        this.metadata.set(MetadataDef.Villager.VARIANT, data);
    }

    @Override
    @Nullable
    protected <T> T get(@NotNull DataComponent<T> component) {
        if (component == DataComponents.VILLAGER_VARIANT) {
            return (T)this.getVillagerData().type();
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(@NotNull DataComponent<T> component, @NotNull T value) {
        if (component == DataComponents.VILLAGER_VARIANT) {
            this.setVillagerData(this.getVillagerData().withType((VillagerType)value));
        } else {
            super.set(component, value);
        }
    }

    public record VillagerData(@NotNull VillagerType type, @NotNull VillagerProfession profession, @NotNull Level level) {
        public static final VillagerData DEFAULT = new VillagerData(VillagerType.DESERT, VillagerProfession.NONE, Level.NOVICE);
        public static final NetworkBuffer.Type<VillagerData> NETWORK_TYPE = NetworkBufferTemplate.template(VillagerType.NETWORK_TYPE, VillagerData::type, VillagerProfession.NETWORK_TYPE, VillagerData::profession, Level.NETWORK_TYPE, VillagerData::level, VillagerData::new);

        @NotNull
        public VillagerData withType(@NotNull VillagerType type) {
            return new VillagerData(type, this.profession, this.level);
        }

        @NotNull
        public VillagerData withProfession(@NotNull VillagerProfession profession) {
            return new VillagerData(this.type, profession, this.level);
        }

        @NotNull
        public VillagerData withLevel(@NotNull Level level) {
            return new VillagerData(this.type, this.profession, level);
        }
    }

    public static enum Level {
        NOVICE,
        APPRENTICE,
        JOURNEYMAN,
        EXPERT,
        MASTER;

        public static final NetworkBuffer.Type<Level> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Level.class);
        }
    }
}

