/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.event.Event;
import net.minestom.server.event.trait.CancellableEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface EventListener<T extends Event> {
    @NotNull
    public Class<T> eventType();

    @NotNull
    public Result run(@NotNull T var1);

    @Contract(pure=true)
    public static <T extends Event> @NotNull Builder<T> builder(@NotNull Class<T> eventType) {
        return new Builder<T>(eventType);
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends Event> EventListener<T> of(@NotNull Class<T> eventType, @NotNull @NotNull Consumer<@NotNull T> listener) {
        return EventListener.builder(eventType).handler(listener).build();
    }

    public static class Builder<T extends Event> {
        private final Class<T> eventType;
        private final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
        private boolean ignoreCancelled = true;
        private int expireCount;
        private Predicate<T> expireWhen;
        private Consumer<T> handler;

        protected Builder(Class<T> eventType) {
            this.eventType = eventType;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> filter(Predicate<T> filter) {
            this.filters.add(filter);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> ignoreCancelled(boolean ignoreCancelled) {
            this.ignoreCancelled = ignoreCancelled;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> expireCount(int expireCount) {
            this.expireCount = expireCount;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> expireWhen(Predicate<T> expireWhen) {
            this.expireWhen = expireWhen;
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder<T> handler(Consumer<T> handler) {
            this.handler = handler;
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public EventListener<T> build() {
            final boolean ignoreCancelled = this.ignoreCancelled;
            final AtomicInteger expirationCount = new AtomicInteger(this.expireCount);
            final boolean hasExpirationCount = expirationCount.get() > 0;
            final Predicate<T> expireWhen = this.expireWhen;
            final ArrayList<Predicate<T>> filters = new ArrayList<Predicate<T>>(this.filters);
            final Consumer<T> handler = this.handler;
            return new EventListener<T>(){

                @Override
                @NotNull
                public Class<T> eventType() {
                    return eventType;
                }

                @Override
                @NotNull
                public Result run(@NotNull T event) {
                    if (ignoreCancelled && event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) {
                        return Result.INVALID;
                    }
                    if (expireWhen != null && expireWhen.test(event)) {
                        return Result.EXPIRED;
                    }
                    if (!filters.isEmpty()) {
                        for (Predicate filter : filters) {
                            if (filter.test(event)) continue;
                            return Result.INVALID;
                        }
                    }
                    if (handler != null) {
                        handler.accept(event);
                    }
                    if (hasExpirationCount && expirationCount.decrementAndGet() == 0) {
                        return Result.EXPIRED;
                    }
                    return Result.SUCCESS;
                }
            };
        }
    }

    public static enum Result {
        SUCCESS,
        INVALID,
        EXPIRED,
        EXCEPTION;

    }
}

