/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.banner;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.instance.block.banner.BannerPatternImpl;
import net.minestom.server.instance.block.banner.BannerPatterns;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public sealed interface BannerPattern
extends Holder.Direct<BannerPattern>,
BannerPatterns
permits BannerPatternImpl {
    @NotNull
    public static final NetworkBuffer.Type<BannerPattern> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.KEY, BannerPattern::assetId, NetworkBuffer.STRING, BannerPattern::translationKey, BannerPattern::create);
    @NotNull
    public static final Codec<BannerPattern> REGISTRY_CODEC = StructCodec.struct("asset_id", Codec.KEY, BannerPattern::assetId, "translation_key", Codec.STRING, BannerPattern::translationKey, BannerPattern::create);
    @NotNull
    public static final NetworkBuffer.Type<Holder<BannerPattern>> HOLDER_NETWORK_TYPE = Holder.networkType(Registries::bannerPattern, REGISTRY_NETWORK_TYPE);
    @NotNull
    public static final Codec<Holder<BannerPattern>> HOLDER_CODEC = Holder.codec(Registries::bannerPattern, REGISTRY_CODEC);

    @NotNull
    public static BannerPattern create(@NotNull Key assetId, @NotNull String translationKey) {
        return new BannerPatternImpl(assetId, translationKey);
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    @NotNull
    public static DynamicRegistry<BannerPattern> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("minecraft:banner_pattern"), REGISTRY_CODEC, RegistryData.Resource.BANNER_PATTERNS);
    }

    @NotNull
    public Key assetId();

    @NotNull
    public String translationKey();

    public static final class Builder {
        private Key assetId;
        private String translationKey;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder assetId(@NotNull Key assetId) {
            this.assetId = assetId;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        @NotNull
        public Builder translationKey(@NotNull String translationKey) {
            this.translationKey = translationKey;
            return this;
        }

        @Contract(pure=true)
        @NotNull
        public BannerPattern build() {
            return new BannerPatternImpl(this.assetId, this.translationKey);
        }
    }
}

