/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.palette;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.IntUnaryOperator;
import net.minestom.server.instance.palette.AdaptivePalette;
import net.minestom.server.instance.palette.PaletteIndirect;
import net.minestom.server.instance.palette.PaletteSingle;
import net.minestom.server.instance.palette.Palettes;
import net.minestom.server.instance.palette.SpecializedPalette;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public interface Palette {
    public static final NetworkBuffer.Type<Palette> BLOCK_SERIALIZER = Palette.serializer(16, 4, 8);
    public static final NetworkBuffer.Type<Palette> BIOME_SERIALIZER = Palette.serializer(4, 1, 3);

    public static Palette blocks() {
        return Palette.newPalette(16, 8, 4);
    }

    public static Palette biomes() {
        return Palette.newPalette(4, 3, 1);
    }

    public static Palette newPalette(int dimension, int maxBitsPerEntry, int bitsPerEntry) {
        return new AdaptivePalette((byte)dimension, (byte)maxBitsPerEntry, (byte)bitsPerEntry);
    }

    public int get(int var1, int var2, int var3);

    public void getAll(@NotNull EntryConsumer var1);

    public void getAllPresent(@NotNull EntryConsumer var1);

    public void set(int var1, int var2, int var3, int var4);

    public void fill(int var1);

    public void setAll(@NotNull EntrySupplier var1);

    public void replace(int var1, int var2, int var3, @NotNull IntUnaryOperator var4);

    public void replaceAll(@NotNull EntryFunction var1);

    public int count();

    public int bitsPerEntry();

    public int maxBitsPerEntry();

    public int dimension();

    default public int maxSize() {
        int dimension = this.dimension();
        return dimension * dimension * dimension;
    }

    @NotNull
    public Palette clone();

    public static NetworkBuffer.Type<Palette> serializer(final int dimension, final int minIndirect, final int maxIndirect) {
        return new NetworkBuffer.Type<Palette>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, Palette value) {
                Palette palette = value;
                Objects.requireNonNull(palette);
                Palette palette2 = palette;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdaptivePalette.class, PaletteSingle.class, PaletteIndirect.class}, (Object)palette2, n)) {
                    case 0: {
                        SpecializedPalette optimized;
                        AdaptivePalette adaptive = (AdaptivePalette)palette2;
                        adaptive.palette = optimized = adaptive.optimizedPalette();
                        BLOCK_SERIALIZER.write(buffer, optimized);
                        break;
                    }
                    case 1: {
                        PaletteSingle single = (PaletteSingle)palette2;
                        buffer.write(NetworkBuffer.BYTE, (byte)0);
                        buffer.write(NetworkBuffer.VAR_INT, single.value());
                        break;
                    }
                    case 2: {
                        PaletteIndirect indirect = (PaletteIndirect)palette2;
                        buffer.write(NetworkBuffer.BYTE, (byte)value.bitsPerEntry());
                        if (indirect.bitsPerEntry() <= indirect.maxBitsPerEntry()) {
                            buffer.write(NetworkBuffer.VAR_INT.list(), indirect.paletteToValueList);
                        }
                        for (long l : indirect.values) {
                            buffer.write(NetworkBuffer.LONG, l);
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported palette type: " + String.valueOf(value.getClass()));
                    }
                }
            }

            @Override
            public Palette read(@NotNull NetworkBuffer buffer) {
                byte bitsPerEntry = buffer.read(NetworkBuffer.BYTE);
                if (bitsPerEntry == 0) {
                    int value = buffer.read(NetworkBuffer.VAR_INT);
                    return new PaletteSingle((byte)dimension, value);
                }
                if (bitsPerEntry >= minIndirect && bitsPerEntry <= maxIndirect) {
                    int[] palette = buffer.read(NetworkBuffer.VAR_INT_ARRAY);
                    int entriesPerLong = 64 / bitsPerEntry;
                    long[] data = new long[dimension * dimension * dimension / entriesPerLong + 1];
                    for (int i = 0; i < data.length; ++i) {
                        data[i] = buffer.read(NetworkBuffer.LONG);
                    }
                    return new PaletteIndirect(dimension, maxIndirect, bitsPerEntry, Palettes.count(bitsPerEntry, data), palette, data);
                }
                long[] data = buffer.read(NetworkBuffer.LONG_ARRAY);
                return new PaletteIndirect(dimension, maxIndirect, bitsPerEntry, Palettes.count(bitsPerEntry, data), new int[0], data);
            }
        };
    }

    @FunctionalInterface
    public static interface EntryFunction {
        public int apply(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(int var1, int var2, int var3, int var4);
    }

    @FunctionalInterface
    public static interface EntrySupplier {
        public int get(int var1, int var2, int var3);
    }
}

