/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.List;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record ChunkBiomesPacket(@NotNull @NotNull List<@NotNull ChunkBiomeData> chunks) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<ChunkBiomesPacket> SERIALIZER = NetworkBufferTemplate.template(ChunkBiomeData.SERIALIZER.list(), ChunkBiomesPacket::chunks, ChunkBiomesPacket::new);

    public ChunkBiomesPacket(@NotNull List<ChunkBiomeData> chunks) {
        chunks = List.copyOf(chunks);
    }

    public record ChunkBiomeData(int chunkX, int chunkZ, byte[] data) {
        public static final NetworkBuffer.Type<ChunkBiomeData> SERIALIZER = new NetworkBuffer.Type<ChunkBiomeData>(){

            @Override
            public void write(@NotNull NetworkBuffer buffer, ChunkBiomeData value) {
                buffer.write(NetworkBuffer.INT, value.chunkZ);
                buffer.write(NetworkBuffer.INT, value.chunkX);
                buffer.write(NetworkBuffer.BYTE_ARRAY, value.data);
            }

            @Override
            public ChunkBiomeData read(@NotNull NetworkBuffer buffer) {
                int chunkZ = buffer.read(NetworkBuffer.INT);
                int chunkX = buffer.read(NetworkBuffer.INT);
                byte[] data = buffer.read(NetworkBuffer.BYTE_ARRAY);
                return new ChunkBiomeData(chunkX, chunkZ, data);
            }
        };
    }
}

