/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.network.packet.server.play;

import java.util.UUID;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.packet.server.ServerPacket;
import org.jetbrains.annotations.NotNull;

public record SpawnEntityPacket(int entityId, @NotNull UUID uuid, int type, @NotNull Pos position, float headRot, int data, short velocityX, short velocityY, short velocityZ) implements ServerPacket.Play
{
    public static final NetworkBuffer.Type<SpawnEntityPacket> SERIALIZER = new NetworkBuffer.Type<SpawnEntityPacket>(){

        @Override
        public void write(@NotNull NetworkBuffer buffer, @NotNull SpawnEntityPacket value) {
            buffer.write(NetworkBuffer.VAR_INT, value.entityId);
            buffer.write(NetworkBuffer.UUID, value.uuid);
            buffer.write(NetworkBuffer.VAR_INT, value.type);
            buffer.write(NetworkBuffer.DOUBLE, value.position.x());
            buffer.write(NetworkBuffer.DOUBLE, value.position.y());
            buffer.write(NetworkBuffer.DOUBLE, value.position.z());
            buffer.write(NetworkBuffer.BYTE, (byte)(value.position.pitch() * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BYTE, (byte)(value.position.yaw() * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.BYTE, (byte)(value.headRot * 256.0f / 360.0f));
            buffer.write(NetworkBuffer.VAR_INT, value.data);
            buffer.write(NetworkBuffer.SHORT, value.velocityX);
            buffer.write(NetworkBuffer.SHORT, value.velocityY);
            buffer.write(NetworkBuffer.SHORT, value.velocityZ);
        }

        @Override
        @NotNull
        public SpawnEntityPacket read(@NotNull NetworkBuffer buffer) {
            return new SpawnEntityPacket(buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.UUID), buffer.read(NetworkBuffer.VAR_INT), new Pos(buffer.read(NetworkBuffer.DOUBLE), buffer.read(NetworkBuffer.DOUBLE), buffer.read(NetworkBuffer.DOUBLE), (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f), (float)buffer.read(NetworkBuffer.BYTE).byteValue() * 360.0f / 256.0f, buffer.read(NetworkBuffer.VAR_INT), buffer.read(NetworkBuffer.SHORT), buffer.read(NetworkBuffer.SHORT), buffer.read(NetworkBuffer.SHORT));
        }
    };
}

