/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.recipe.display;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.NotNull;

public enum SlotDisplayType implements StaticProtocolObject<SlotDisplayType>
{
    EMPTY(Key.key("minecraft:empty")),
    ANY_FUEL(Key.key("minecraft:any_fuel")),
    ITEM(Key.key("minecraft:item")),
    ITEM_STACK(Key.key("minecraft:item_stack")),
    TAG(Key.key("minecraft:tag")),
    SMITHING_TRIM(Key.key("minecraft:smithing_trim")),
    WITH_REMAINDER(Key.key("minecraft:with_remainder")),
    COMPOSITE(Key.key("minecraft:composite"));

    private static final Map<Key, SlotDisplayType> BY_KEY;
    public static final NetworkBuffer.Type<SlotDisplayType> NETWORK_TYPE;
    public static final Codec<SlotDisplayType> CODEC;
    private final Key key;

    private SlotDisplayType(Key key) {
        this.key = key;
    }

    @Override
    @NotNull
    public Key key() {
        return this.key;
    }

    @Override
    public int id() {
        return this.ordinal();
    }

    static {
        BY_KEY = Arrays.stream(SlotDisplayType.values()).collect(Collectors.toMap(SlotDisplayType::key, Function.identity()));
        NETWORK_TYPE = NetworkBuffer.Enum(SlotDisplayType.class);
        CODEC = Codec.KEY.transform(BY_KEY::get, SlotDisplayType::key);
    }
}

