/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.registry;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.minestom.server.codec.Codec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryCodecs;
import net.minestom.server.registry.TagKeyImpl;
import org.jetbrains.annotations.NotNull;

public sealed interface TagKey<T>
extends Keyed
permits TagKeyImpl {
    @NotNull
    public static <T> Codec<TagKey<T>> codec(@NotNull Registries.Selector<T> selector) {
        return new RegistryCodecs.TagKeyImpl<T>(selector, false);
    }

    @NotNull
    public static <T> Codec<TagKey<T>> hashCodec(@NotNull Registries.Selector<T> selector) {
        return new RegistryCodecs.TagKeyImpl<T>(selector, true);
    }

    public static <T> @NotNull NetworkBuffer.Type<TagKey<T>> networkType(@NotNull Registries.Selector<T> selector) {
        return NetworkBuffer.KEY.transform(TagKeyImpl::new, Keyed::key);
    }

    @NotNull
    public static <T> TagKey<T> ofHash(@NotNull String hashedKey) {
        if (!hashedKey.startsWith("#")) {
            throw new IllegalArgumentException("Hashed key must start with '#': " + hashedKey);
        }
        return new TagKeyImpl(Key.key(hashedKey.substring(1)));
    }

    @NotNull
    default public String hashedKey() {
        return "#" + this.key().asString();
    }
}

