/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.scoreboard;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.network.packet.server.play.ScoreboardObjectivePacket;
import net.minestom.server.scoreboard.Scoreboard;
import org.jetbrains.annotations.NotNull;

public class TabList
implements Scoreboard {
    private static final String TAB_LIST_PREFIX = "tl-";
    private final Set<Player> viewers = new CopyOnWriteArraySet<Player>();
    private final Set<Player> unmodifiableViewers = Collections.unmodifiableSet(this.viewers);
    private final String objectiveName;
    private ScoreboardObjectivePacket.Type type;

    public TabList(String name, ScoreboardObjectivePacket.Type type) {
        this.objectiveName = TAB_LIST_PREFIX + name;
        this.type = type;
    }

    public ScoreboardObjectivePacket.Type getType() {
        return this.type;
    }

    public void setType(ScoreboardObjectivePacket.Type type) {
        this.type = type;
    }

    @Override
    public boolean addViewer(@NotNull Player player) {
        boolean result = this.viewers.add(player);
        if (result) {
            player.sendPacket(this.getCreationObjectivePacket(Component.empty(), this.type));
            player.sendPacket(this.getDisplayScoreboardPacket((byte)0));
        }
        return result;
    }

    @Override
    public boolean removeViewer(@NotNull Player player) {
        boolean result = this.viewers.remove(player);
        if (result) {
            player.sendPacket(this.getDestructionObjectivePacket());
        }
        return result;
    }

    @Override
    @NotNull
    public Set<Player> getViewers() {
        return this.unmodifiableViewers;
    }

    @Override
    public String getObjectiveName() {
        return this.objectiveName;
    }
}

