/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.AICommand;
import io.github.pronze.sba.commands.GamesInvNPCCommand;
import io.github.pronze.sba.commands.SBACommand;
import io.github.pronze.sba.commands.ShoutCommand;
import io.github.pronze.sba.commands.party.PartyCommand;
import io.github.pronze.sba.utils.SBAUtil;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.AnnotationParser;
import sba.cl.annotations.Argument;
import sba.cl.annotations.CommandDescription;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.specifier.Greedy;
import sba.cl.arguments.parser.ParserParameters;
import sba.cl.arguments.parser.StandardParameters;
import sba.cl.bukkit.CloudBukkitCapabilities;
import sba.cl.execution.CommandExecutionCoordinator;
import sba.cl.meta.CommandMeta;
import sba.cl.minecraft.extras.MinecraftHelp;
import sba.cl.paper.PaperCommandManager;
import sba.k.a.p.bukkit.BukkitAudiences;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnEnable;

@Service
@ServiceDependencies(initAnother={SBACommand.class, GamesInvNPCCommand.class, ShoutCommand.class, PartyCommand.class, AICommand.class})
public class CommandManager {
    private PaperCommandManager<CommandSender> manager;
    private AnnotationParser<CommandSender> annotationParser;
    private MinecraftHelp<CommandSender> minecraftHelp;
    @NotNull
    private BukkitAudiences bukkitAudiences;

    public static CommandManager getInstance() {
        return ServiceManager.get(CommandManager.class);
    }

    public static void reload() {
        if (SBA.isBroken()) {
            return;
        }
        CommandManager ths = CommandManager.getInstance();
        if (ths != null) {
            ths.bukkitAudiences = BukkitAudiences.create((Plugin)SBA.getPluginInstance());
            ths.minecraftHelp = new MinecraftHelp<CommandSender>("/sba help", ths.bukkitAudiences::sender, ths.manager);
        }
    }

    @OnEnable
    public void onEnable(JavaPlugin plugin) {
        if (SBA.isBroken()) {
            return;
        }
        if (this.manager != null) {
            return;
        }
        if (SBA.isBroken()) {
            return;
        }
        Function executionCoordinatorFunction = CommandExecutionCoordinator.simpleCoordinator();
        Function mapperFunction = Function.identity();
        try {
            this.manager = new PaperCommandManager((Plugin)plugin, executionCoordinatorFunction, mapperFunction, mapperFunction);
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Failed to initialize the command manager");
            SBAUtil.disablePlugin(plugin);
            return;
        }
        this.bukkitAudiences = BukkitAudiences.create((Plugin)plugin);
        this.minecraftHelp = new MinecraftHelp<CommandSender>("/sba help", this.bukkitAudiences::sender, this.manager);
        if (this.manager.queryCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            this.manager.registerAsynchronousCompletions();
        }
        Function<ParserParameters, CommandMeta> commandMetaFunction = p -> CommandMeta.simple().with(CommandMeta.DESCRIPTION, p.get(StandardParameters.DESCRIPTION, "No description")).build();
        this.annotationParser = new AnnotationParser<CommandSender>(this.manager, CommandSender.class, commandMetaFunction);
        this.annotationParser.parse(this);
    }

    @CommandMethod(value="sba help [query]")
    @CommandDescription(value="Help menu")
    private void commandHelp(@NonNull CommandSender sender, @Argument(value="query") @Greedy String query) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        sender.sendMessage("commandHelp");
        this.minecraftHelp.queryCommands(query == null ? "" : query, sender);
    }

    public PaperCommandManager<CommandSender> getManager() {
        return this.manager;
    }

    public AnnotationParser<CommandSender> getAnnotationParser() {
        return this.annotationParser;
    }

    public MinecraftHelp<CommandSender> getMinecraftHelp() {
        return this.minecraftHelp;
    }

    @NotNull
    public BukkitAudiences getBukkitAudiences() {
        return this.bukkitAudiences;
    }
}

