/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.lib.nms.entity.PlayerUtils;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.pa.Players;
import sba.sl.s.CommandSender;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartyWarpCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p warp")
    @CommandPermission(value="sba.party")
    private void commandWarp(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!player.equals(party.getPartyLeader())) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            if (party.getMembers().size() == 1) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NO_PLAYERS_TO_WARP).send(player);
                return;
            }
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_WARP).send(player);
            if (Main.getInstance().isPlayerPlayingAnyGame(playerArg)) {
                Game game = Main.getInstance().getGameOfPlayer(playerArg);
                party.getMembers().stream().filter(member -> !player.equals(member)).forEach(member -> {
                    Game memberGame = Main.getInstance().getGameOfPlayer(member.getInstance());
                    Bukkit.getScheduler().runTask((Plugin)SBA.getPluginInstance(), () -> {
                        if (player.getInstance() != member.getInstance() && game != memberGame) {
                            if (memberGame != null) {
                                memberGame.leaveFromGame(member.getInstance());
                            }
                            game.joinToGame(member.getInstance());
                            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_WARP).send((CommandSender)member);
                        }
                    });
                });
            } else {
                Location leaderLocation = player.getInstance().getLocation();
                party.getMembers().stream().filter(member -> !member.equals(player)).forEach(member -> {
                    if (Main.getInstance().isPlayerPlayingAnyGame(member.getInstance())) {
                        Main.getInstance().getGameOfPlayer(member.getInstance()).leaveFromGame(member.getInstance());
                    }
                    PlayerUtils.teleportPlayer((Player)member.getInstance(), (Location)leaderLocation);
                    LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_LEADER_JOIN_LEAVE).send(Players.wrapPlayer(member.getInstance()));
                });
            }
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }
}

