/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.config;

import io.github.pronze.sba.utils.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import sba.si.inventory.Price;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;

@Service
public class QuickBuyConfig {
    private JavaPlugin plugin;
    private File directory;
    private Map<UUID, UserQuickBuyConfig> config = new HashMap<UUID, UserQuickBuyConfig>();

    public static QuickBuyConfig getInstance() {
        return ServiceManager.get(QuickBuyConfig.class);
    }

    public QuickBuyConfig(JavaPlugin plugin) {
        this.plugin = plugin;
        this.directory = plugin.getDataFolder().toPath().resolve("quickbuy").toFile();
        this.load();
    }

    public UserQuickBuyConfig of(OfflinePlayer op) {
        if (!this.config.containsKey(op.getUniqueId())) {
            this.config.put(op.getUniqueId(), new UserQuickBuyConfig(op.getUniqueId()));
        }
        return this.config.get(op.getUniqueId());
    }

    public void load() {
        try {
            this.directory.mkdir();
        }
        catch (Throwable t) {
            Logger.error("Could not create quickbuy directory due to {}", t);
        }
        Arrays.stream(this.directory.listFiles()).forEach(file -> {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            String fileName = file.getName();
            String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46));
            UserQuickBuyConfig userConfig = new UserQuickBuyConfig(UUID.fromString(fileNameWithoutExtension));
            config.getKeys(false).forEach(arg_0 -> QuickBuyConfig.lambda$load$0((FileConfiguration)config, userConfig, arg_0));
            this.config.put(userConfig.userId(), userConfig);
        });
    }

    public void save() {
        try {
            this.directory.mkdir();
        }
        catch (Throwable t) {
            Logger.error("Could not create quickbuy directory due to {}", t);
        }
        this.config.values().forEach(this::save);
    }

    public void save(UserQuickBuyConfig userConfig) {
        File file = new File(String.valueOf(this.directory) + File.separator + String.valueOf(userConfig.userId()) + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        userConfig.items().forEach((arg_0, arg_1) -> QuickBuyConfig.lambda$save$2((FileConfiguration)config, arg_0, arg_1));
        try {
            config.save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static /* synthetic */ void lambda$save$2(FileConfiguration config, String section, UserQuickBuyConfig.QuickBuyItem content) {
        ConfigurationSection sectionYaml = config.createSection(section);
        sectionYaml.set("material", (Object)content.material.toString());
        sectionYaml.set("amount", (Object)content.amount());
        sectionYaml.set("resource", (Object)content.resource());
    }

    private static /* synthetic */ void lambda$load$0(FileConfiguration config, UserQuickBuyConfig userConfig, String key) {
        ConfigurationSection section = config.getConfigurationSection(key);
        int amount = section.getInt("amount");
        String resource = section.getString("resource");
        String material = section.getString("material");
        Material mat = Material.valueOf((String)material);
        userConfig.set(key, mat, Price.of(amount, resource));
    }

    public class UserQuickBuyConfig {
        private Map<String, QuickBuyItem> items = new HashMap<String, QuickBuyItem>();
        @NonNull
        private UUID userId;

        public UserQuickBuyConfig save() {
            QuickBuyConfig.this.save(this);
            return this;
        }

        public QuickBuyItem of(String id) {
            return this.items.get(id);
        }

        public UserQuickBuyConfig set(String id, QuickBuyItem val) {
            this.items.put(id, val);
            return this;
        }

        public UserQuickBuyConfig set(String quickBuyId, @NotNull Material type, Price price) {
            QuickBuyItem item = new QuickBuyItem(type, price.getAmount(), price.getCurrency());
            return this.set(quickBuyId, item);
        }

        public Map<String, QuickBuyItem> items() {
            return this.items;
        }

        @NonNull
        public UUID userId() {
            return this.userId;
        }

        public UserQuickBuyConfig items(Map<String, QuickBuyItem> items) {
            this.items = items;
            return this;
        }

        public UserQuickBuyConfig userId(@NonNull UUID userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserQuickBuyConfig)) {
                return false;
            }
            UserQuickBuyConfig other = (UserQuickBuyConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, QuickBuyItem> this$items = this.items();
            Map<String, QuickBuyItem> other$items = other.items();
            if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
                return false;
            }
            UUID this$userId = this.userId();
            UUID other$userId = other.userId();
            return !(this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UserQuickBuyConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, QuickBuyItem> $items = this.items();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            UUID $userId = this.userId();
            result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
            return result;
        }

        public String toString() {
            return "QuickBuyConfig.UserQuickBuyConfig(items=" + String.valueOf(this.items()) + ", userId=" + String.valueOf(this.userId()) + ")";
        }

        public UserQuickBuyConfig(UUID userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
        }

        public class QuickBuyItem {
            private Material material;
            private int amount;
            private String resource;

            public QuickBuyItem save() {
                UserQuickBuyConfig.this.save();
                return this;
            }

            public Material material() {
                return this.material;
            }

            public int amount() {
                return this.amount;
            }

            public String resource() {
                return this.resource;
            }

            public QuickBuyItem material(Material material) {
                this.material = material;
                return this;
            }

            public QuickBuyItem amount(int amount) {
                this.amount = amount;
                return this;
            }

            public QuickBuyItem resource(String resource) {
                this.resource = resource;
                return this;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof QuickBuyItem)) {
                    return false;
                }
                QuickBuyItem other = (QuickBuyItem)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.amount() != other.amount()) {
                    return false;
                }
                Material this$material = this.material();
                Material other$material = other.material();
                if (this$material == null ? other$material != null : !this$material.equals(other$material)) {
                    return false;
                }
                String this$resource = this.resource();
                String other$resource = other.resource();
                return !(this$resource == null ? other$resource != null : !this$resource.equals(other$resource));
            }

            protected boolean canEqual(Object other) {
                return other instanceof QuickBuyItem;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.amount();
                Material $material = this.material();
                result = result * 59 + ($material == null ? 43 : $material.hashCode());
                String $resource = this.resource();
                result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
                return result;
            }

            public String toString() {
                return "QuickBuyConfig.UserQuickBuyConfig.QuickBuyItem(material=" + String.valueOf(this.material()) + ", amount=" + this.amount() + ", resource=" + this.resource() + ")";
            }

            public QuickBuyItem() {
            }

            public QuickBuyItem(Material material, int amount, String resource) {
                this.material = material;
                this.amount = amount;
                this.resource = resource;
            }
        }
    }
}

