/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.fix;

import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.fix.BaseFix;
import io.github.pronze.sba.utils.Logger;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class CitizensFix
extends BaseFix {
    private boolean isProblematic = false;
    private boolean isCritical = false;

    @Override
    public void detect() {
        boolean isViaEnabled = Bukkit.getPluginManager().isPluginEnabled("Citizens");
        if (isViaEnabled) {
            Plugin viaVersion = Bukkit.getPluginManager().getPlugin("Citizens");
            this.isCritical = viaVersion.getDescription().getVersion().contains("2.0.2");
            this.isProblematic = !viaVersion.getDescription().getVersion().contains("2.0.30") && viaVersion.getDescription().getVersion().contains("2.0.31");
        }
    }

    public boolean canEnable() {
        return Bukkit.getServer().getPluginManager().getPlugin("Citizens") != null && Bukkit.getServer().getPluginManager().getPlugin("Citizens").isEnabled() && !this.isCritical;
    }

    @Override
    public void fix(SBAConfig cfg) {
        if (this.isCritical) {
            SBAConfig.getInstance().ai().disable();
        }
    }

    @Override
    public void warn() {
        Logger.warn("Only Citizens 2.0.30/31 is currently supported as Citizens API change frequently. 2.0.32+ might or might not work.", new Object[0]);
        if (this.isCritical) {
            Logger.error("SBA Will totally disable AI", new Object[0]);
        }
    }

    @Override
    public boolean IsProblematic() {
        return this.isProblematic;
    }

    @Override
    public boolean IsCritical() {
        return false;
    }
}

