/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.game.tasks;

import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.tasks.BaseGameTask;
import io.github.pronze.sba.game.tasks.CustomTrapTask;
import io.github.pronze.sba.game.tasks.GeneratorTask;
import io.github.pronze.sba.game.tasks.HealPoolTask;
import io.github.pronze.sba.game.tasks.MinerTrapTask;
import io.github.pronze.sba.game.tasks.TrapTask;
import io.github.pronze.sba.manager.IGameTaskManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import sba.sl.pu.ServiceManager;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;

@Service
@ServiceDependencies(dependsOn={SBAConfig.class})
public class GameTaskManager
implements IGameTaskManager {
    public static GameTaskManager getInstance() {
        return ServiceManager.get(GameTaskManager.class);
    }

    @Override
    public List<BaseGameTask> startTasks(@NotNull IArena arena) {
        ArrayList<BaseGameTask> l = new ArrayList<BaseGameTask>(4);
        l.add(new GeneratorTask());
        l.add(new HealPoolTask());
        l.add(new TrapTask());
        l.add(new MinerTrapTask());
        l.add(new CustomTrapTask());
        return l.stream().map(task -> task.start(arena)).collect(Collectors.toList());
    }
}

