/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.inventories;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.QuickBuyConfig;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.IStoreInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToBoughtItem;
import org.screamingsandals.bedwars.api.events.BedwarsApplyPropertyToDisplayedItem;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.GameStore;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import org.screamingsandals.bedwars.utils.Sounds;
import sba.si.builder.InventorySetBuilder;
import sba.si.events.ItemRenderEvent;
import sba.si.events.OnTradeEvent;
import sba.si.events.PreClickEvent;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.Include;
import sba.si.inventory.InventorySet;
import sba.si.inventory.PlayerItemInfo;
import sba.si.inventory.Price;
import sba.si.inventory.Property;
import sba.si.inventory.SubInventory;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.u.ClickType;
import sba.sl.u.ConfigurateUtils;
import sba.sl.u.annotations.methods.OnPostEnable;

public abstract class AbstractStoreInventory
implements IStoreInventory,
Listener {
    private final Map<String, InventorySet> shopMap = new HashMap<String, InventorySet>();
    @NotNull
    private final String shopPaths;
    private Map<UUID, String> userInQuickBuy = new HashMap<UUID, String>();

    @OnPostEnable
    public void onPostEnable() {
        if (SBA.isBroken()) {
            return;
        }
        if (this.shopPaths.length() > 0) {
            Arrays.stream(this.shopPaths.split(",")).forEach(path -> SBAConfig.getInstance().saveShop((String)path, false));
        }
        SBA.getInstance().registerListener(this);
        this.loadNewShop("default", null, true);
    }

    public Optional<InventorySet> getInventory(String key) {
        return Optional.ofNullable(this.shopMap.get(key));
    }

    public InventorySet iterate(@NotNull GameStore store) {
        try {
            boolean parent = true;
            parent = store.getUseParent();
            String fileName = store.getShopFile();
            if (fileName != null) {
                File file;
                String name = (parent ? "+" : "-") + (file = ShopUtil.normalizeShopFile(fileName)).getAbsolutePath();
                if (!this.shopMap.containsKey(name)) {
                    this.loadNewShop(name, file, parent);
                }
                return this.shopMap.get(name);
            }
        }
        catch (Throwable ignored) {
            Logger.error("[SBA] Your shop is invalid! Check it out or contact us on Discord. {}", ignored);
        }
        return null;
    }

    @Override
    public void openForPlayer(@NotNull SBAPlayerWrapper player, @NotNull GameStore store) {
        try {
            boolean parent = true;
            parent = store.getUseParent();
            String fileName = store.getShopFile();
            if (fileName != null) {
                File file;
                String name = (parent ? "+" : "-") + (file = ShopUtil.normalizeShopFile(fileName)).getAbsolutePath();
                if (!this.shopMap.containsKey(name)) {
                    this.loadNewShop(name, file, parent);
                }
                player.openInventory(this.shopMap.get(name));
            } else {
                player.openInventory(this.shopMap.get("default"));
            }
        }
        catch (Throwable ignored) {
            Logger.error("[SBA] Your shop is invalid! Check it out or contact us on Discord. {}", ignored);
            player.sendMessage("[SBA] Your shop is invalid! Check it out or contact us on Discord.");
        }
    }

    @Override
    public void loadNewShop(@NotNull String name, @Nullable File file, boolean useParent) {
        InventorySet inventorySet = ((InventorySetBuilder)this.getInventorySetBuilder().genericShop(true).genericShopPriceTypeRequired(true).animationsEnabled(true).call(categoryBuilder -> {
            Object pathStr = SBA.getBedwarsPlugin().getDataFolder().getAbsolutePath();
            pathStr = (String)pathStr + "/" + (file != null ? file.getName() : "shop.yml");
            categoryBuilder.include(Include.of(Paths.get((String)pathStr, new String[0])));
        })).preClick(this::onPreAction).buy(this::onShopTransaction).render(this::onGeneratingItem).getInventorySet();
        try {
            inventorySet.getMainSubInventory().process();
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("Wrong shop.yml configuration!");
            Bukkit.getLogger().warning("Check validity of your YAML!");
            ex.printStackTrace();
        }
        this.shopMap.put(name, inventorySet);
    }

    private void loadDefault(InventorySet inventorySet) {
        inventorySet.getMainSubInventory().dropContents();
        inventorySet.getMainSubInventory().getWaitingQueue().add(Include.of(Path.of(Objects.requireNonNull(SBA.class.getResource("/shops/" + this.shopPaths.split(",")[0])).toURI())));
        inventorySet.getMainSubInventory().process();
    }

    private void onShopTransaction(OnTradeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        this.handlePrePurchase(event);
    }

    private void onPreAction(PreClickEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer().as(Player.class);
        if (!Main.isPlayerInGame((Player)player)) {
            event.setCancelled(true);
        }
        if (Main.getPlayerGameProfile((Player)player).isSpectator) {
            event.setCancelled(true);
        }
    }

    public void handlePrePurchase(OnTradeEvent event) {
        boolean shouldBuyStack;
        boolean shouldSellStack;
        sba.sl.i.ItemStack materialItem;
        Player player = event.getPlayer().as(Player.class);
        Game game = Main.getInstance().getGameOfPlayer(player);
        ClickType clickType = event.getClickType();
        PlayerItemInfo itemInfo = event.getItem();
        ItemStack newItem = event.getStack().as(ItemStack.class);
        Price price = event.getPrices().get(0);
        boolean isQuickBuy = itemInfo.getProperties().stream().anyMatch(prop -> prop.hasName() && prop.getPropertyName().equals("quickbuy"));
        if (isQuickBuy && clickType.isRightClick()) {
            event.setCancelled(true);
            Logger.trace("Entering quickbuy edit mode", new Object[0]);
            String quickBuyId = itemInfo.getProperties().stream().filter(prop -> prop.hasName() && prop.getPropertyName().equals("quickbuy")).findAny().map(x -> x.getPropertyData().childrenMap().get("id").getString()).orElse("");
            this.userInQuickBuy.put(player.getUniqueId(), quickBuyId);
            return;
        }
        if (!isQuickBuy && this.userInQuickBuy.containsKey(player.getUniqueId())) {
            Logger.trace("Setting up quick item as{} {}", price, newItem.getType());
            String quickBuyId = this.userInQuickBuy.get(player.getUniqueId());
            QuickBuyConfig.getInstance().of((OfflinePlayer)player).set(quickBuyId, itemInfo.getOriginal().getItem().as(ItemStack.class).getType(), price).save();
            event.setCancelled(true);
            Logger.trace("Exiting quickbuy edit mode", new Object[0]);
            this.userInQuickBuy.remove(player.getUniqueId());
            return;
        }
        if (isQuickBuy && !clickType.isRightClick()) {
            String quickBuyId = itemInfo.getProperties().stream().filter(prop -> prop.hasName() && prop.getPropertyName().equals("quickbuy")).findAny().map(x -> x.getPropertyData().childrenMap().get("id").getString()).orElse("");
            QuickBuyConfig.UserQuickBuyConfig.QuickBuyItem quickBuyItem = QuickBuyConfig.getInstance().of((OfflinePlayer)player).of(quickBuyId);
            if (quickBuyItem == null) {
                event.setCancelled(true);
                return;
            }
            Price quickBuyPrice = Price.of(quickBuyItem.amount(), quickBuyItem.resource());
            GenericItemInfo gii = this.findInfo(quickBuyItem.material(), quickBuyPrice);
            if (gii == null) {
                event.setCancelled(true);
                return;
            }
            itemInfo = new PlayerItemInfo(event.getPlayer(), this.findInfo(quickBuyItem.material(), quickBuyPrice));
            newItem = itemInfo.getOriginal().getItem().clone().as(ItemStack.class);
            price = quickBuyPrice;
        }
        ItemSpawnerType type = Main.getSpawnerType((String)price.getCurrency().toLowerCase());
        int amount = newItem.getAmount();
        int priceAmount = price.getAmount();
        int inInventory = 0;
        Optional<Property> currencyChanger = itemInfo.getFirstPropertyByName("currencyChanger");
        if (currencyChanger.isPresent()) {
            ItemSpawnerType changeItemType;
            String changeItemToName = currencyChanger.get().getPropertyData().getString();
            if (changeItemToName == null) {
                return;
            }
            String[] split = changeItemToName.trim().split(" ", 2);
            if (split.length == 2) {
                try {
                    amount = Integer.parseInt(split[0]);
                    changeItemToName = split[1].trim();
                    if (changeItemToName.startsWith("of ")) {
                        changeItemToName = changeItemToName.substring(3).trim();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((changeItemType = Main.getSpawnerType((String)changeItemToName)) == null) {
                return;
            }
            newItem = changeItemType.getStack(amount);
        }
        int originalMaxStackSize = newItem.getType().getMaxStackSize();
        if (!event.isHasAnyExecutions() && clickType.isShiftClick() && originalMaxStackSize > 1) {
            double priceOfOne = (double)priceAmount / (double)amount;
            for (ItemStack itemStack : player.getInventory().getContents()) {
                if (itemStack == null || !itemStack.isSimilar(type.getStack())) continue;
                inInventory += itemStack.getAmount();
            }
            double maxStackSize = Main.getInstance().getConfig().getBoolean("sell-max-64-per-click-in-shop") ? Math.min((double)inInventory / priceOfOne, (double)originalMaxStackSize) : (double)inInventory / priceOfOne;
            int finalStackSize = (int)maxStackSize;
            if (finalStackSize > amount) {
                priceAmount = (int)(priceOfOne * (double)finalStackSize);
                newItem.setAmount(finalStackSize);
                amount = finalStackSize;
                newItem.setAmount(amount);
            }
        }
        if (!event.hasPlayerInInventory(materialItem = Objects.requireNonNull(ItemStackFactory.build(type.getStack(priceAmount))))) {
            if (!SBAConfig.getInstance().node("shop", "removePurchaseMessages").getBoolean()) {
                LanguageService.getInstance().get(MessageKeys.CANNOT_BUY).replace("%material%", type.getItemName()).send(event.getPlayer());
            }
            return;
        }
        AtomicReference<String[]> messageOnFail = new AtomicReference<String[]>(MessageKeys.CANNOT_BUY);
        if (event.isHasAnyExecutions()) {
            event.setRunExecutions(true);
            shouldSellStack = true;
            shouldBuyStack = false;
        } else {
            for (Property property : itemInfo.getProperties()) {
                if (!property.hasName()) continue;
                Map<?, ?> converted = ConfigurateUtils.raw(property.getPropertyData());
                if (!(converted instanceof Map)) {
                    converted = ShopUtil.nullValuesAllowingMap("value", converted);
                }
                Map propertyData = converted;
                propertyData.putIfAbsent("name", property.getPropertyName());
                BedwarsApplyPropertyToBoughtItem applyEvent = new BedwarsApplyPropertyToBoughtItem(game, player, newItem, propertyData);
                Logger.trace("Calling event: {} for property: {}", applyEvent.getClass().getSimpleName(), property.getPropertyName());
                SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)applyEvent);
                newItem = applyEvent.getStack();
            }
            AtomicReference<ItemStack> newItemRef = new AtomicReference<ItemStack>(newItem);
            AtomicReference<sba.sl.i.ItemStack> newMaterialItemRef = new AtomicReference<sba.sl.i.ItemStack>(materialItem);
            Map.Entry<Boolean, Boolean> result = this.handlePurchase(player, newItemRef, newMaterialItemRef, itemInfo, (org.screamingsandals.bedwars.api.game.ItemSpawnerType)type, messageOnFail);
            this.attemptLoreRemoval(newItem);
            newItem = newItemRef.get();
            materialItem = newMaterialItemRef.get();
            shouldSellStack = result.getKey();
            shouldBuyStack = result.getValue();
        }
        if (!shouldBuyStack && !shouldSellStack) {
            if (!SBAConfig.getInstance().node("shop", "removePurchaseMessages").getBoolean() && messageOnFail.get() != null) {
                LanguageService.getInstance().get(messageOnFail.get()).replace("%material%", type.getItemName()).send(event.getPlayer());
            }
            return;
        }
        if (shouldBuyStack) {
            this.buyStack(newItem, player);
        }
        if (shouldSellStack) {
            event.sellStack(materialItem);
            if (!SBAConfig.getInstance().node("shop", "removePurchaseMessages").getBoolean()) {
                LanguageService.getInstance().get(MessageKeys.SHOP_PURCHASE_SUCCESS).replace("%item%", ShopUtil.getNameOrCustomNameOfItem(Objects.requireNonNull(ItemStackFactory.build(newItem)))).replace("%material%", type.getItemName()).send(event.getPlayer());
            }
            Sounds.playSound((Player)player, (Location)player.getLocation(), (String)Main.getConfigurator().config.getString("sounds.item_buy.sound"), (Sounds)Sounds.ENTITY_ITEM_PICKUP, (float)((float)Main.getConfigurator().config.getDouble("sounds.item_buy.volume")), (float)((float)Main.getConfigurator().config.getDouble("sounds.item_buy.pitch")));
        }
    }

    private void attemptLoreRemoval(ItemStack newItem) {
        if (newItem.getItemMeta() != null) {
            ItemMeta meta = newItem.getItemMeta();
            if (!meta.hasLore()) {
                meta.setLore(null);
            }
            if (meta.hasLore() && meta.getLore().size() == 0) {
                meta.setLore(null);
            }
            if (meta.hasLore() && meta.getLore().size() == 1 && ((String)meta.getLore().get(0)).trim().length() == 0) {
                meta.setLore(null);
            }
            if (meta.hasLore() && meta.getLore().size() == 1 && ChatColor.stripColor((String)((String)meta.getLore().get(0))).trim().length() == 0) {
                meta.setLore(null);
            }
            if (meta.hasLore() && meta.getLore().size() > 0) {
                meta.getLore().forEach(loreLine -> Logger.trace("ITEM LORE {}", loreLine));
            }
            newItem.setItemMeta(meta);
        }
    }

    private void buyStack(ItemStack newItem, Player player) {
        HashMap noFit = player.getInventory().addItem(new ItemStack[]{newItem});
        if (!noFit.isEmpty()) {
            noFit.forEach((i, stack) -> player.getLocation().getWorld().dropItem(player.getLocation(), stack));
        }
    }

    private void iterateShops(Consumer<SubInventory> consumer, BiConsumer<Price, GenericItemInfo> itemConsumer) {
        this.shopMap.forEach((key, value) -> this.iterateShop((InventorySet)value, consumer, itemConsumer));
    }

    private void iterateShop(@NotNull InventorySet is, @Nullable Consumer<SubInventory> consumer, @Nullable BiConsumer<Price, GenericItemInfo> itemConsumer) {
        this.iterateShop(is.getMainSubInventory(), consumer, itemConsumer, new ArrayList<SubInventory>());
    }

    private void iterateShop(@NotNull SubInventory inv, @Nullable Consumer<SubInventory> consumer, @Nullable BiConsumer<Price, GenericItemInfo> itemConsumer, @NotNull List<SubInventory> visited) {
        if (visited.contains(inv)) {
            return;
        }
        visited.add(inv);
        if (consumer != null) {
            consumer.accept(inv);
        }
        for (GenericItemInfo item : inv.getContents()) {
            for (Price price : item.getPrices()) {
                if (itemConsumer == null) continue;
                itemConsumer.accept(price, item);
            }
            SubInventory childInventory = item.getChildInventory();
            if (childInventory == null) continue;
            this.iterateShop(childInventory, consumer, itemConsumer, visited);
        }
    }

    private GenericItemInfo findInfo(Material m, Price p) {
        AtomicReference ref = new AtomicReference();
        this.iterateShops(null, (pr, gii) -> {
            if (pr.getAmount() == p.getAmount() && pr.getCurrency().equals(p.getCurrency()) && gii.getItem().as(ItemStack.class).getType() == m) {
                GenericItemInfo clone = gii.clone();
                clone.setItem(clone.getItem().clone());
                ref.set(clone);
            }
        });
        return (GenericItemInfo)ref.get();
    }

    private void onGeneratingItem(ItemRenderEvent event) {
        this.onPreGenerateItem(event);
        try {
            List<Price> prices;
            PlayerItemInfo itemInfo = event.getItem();
            boolean isQuickBuy = itemInfo.getProperties().stream().anyMatch(prop -> prop.hasName() && prop.getPropertyName().equals("quickbuy"));
            if (isQuickBuy) {
                String quickBuyId = itemInfo.getProperties().stream().filter(prop -> prop.hasName() && prop.getPropertyName().equals("quickbuy")).findAny().map(x -> x.getPropertyData().childrenMap().get("id").getString()).orElse("");
                QuickBuyConfig.UserQuickBuyConfig.QuickBuyItem quickBuyItem = QuickBuyConfig.getInstance().of((OfflinePlayer)event.getPlayer().as(Player.class)).of(quickBuyId);
                if (quickBuyItem != null) {
                    Price quickBuyPrice = Price.of(quickBuyItem.amount(), quickBuyItem.resource());
                    GenericItemInfo info = this.findInfo(quickBuyItem.material(), quickBuyPrice);
                    if (info != null) {
                        if (info != null) {
                            itemInfo = new PlayerItemInfo(event.getPlayer(), info);
                        }
                        event.setStack(itemInfo.getStack());
                        return;
                    }
                }
            }
            sba.sl.i.ItemStack item = itemInfo.getStack();
            Player player = event.getPlayer().as(Player.class);
            Game game = Main.getInstance().getGameOfPlayer(player);
            if (itemInfo.getStack().getMaterial().is((Object)Material.POTION)) {
                ItemStack itemB = item.as(ItemStack.class);
                Logger.trace("{}", itemB);
            }
            if (!(prices = itemInfo.getOriginal().getPrices()).isEmpty()) {
                Price priceObject = prices.get(0);
                int price = priceObject.getAmount();
                ItemSpawnerType type = Main.getSpawnerType((String)priceObject.getCurrency().toLowerCase());
                if (type == null) {
                    return;
                }
                item = ShopUtil.setLore(item, itemInfo, String.valueOf(price), (org.screamingsandals.bedwars.api.game.ItemSpawnerType)type, player);
                event.setStack(item);
            }
            event.setStack(item);
            itemInfo.getProperties().forEach(property -> {
                if (property.hasName()) {
                    Map<?, ?> converted = ConfigurateUtils.raw(property.getPropertyData());
                    if (!(converted instanceof Map)) {
                        converted = ShopUtil.nullValuesAllowingMap("value", converted);
                    }
                    Map propertyData = converted;
                    propertyData.putIfAbsent("name", property.getPropertyName());
                    BedwarsApplyPropertyToDisplayedItem applyEvent = new BedwarsApplyPropertyToDisplayedItem(game, player, event.getStack().as(ItemStack.class), propertyData);
                    Bukkit.getServer().getPluginManager().callEvent((Event)applyEvent);
                    event.setStack(Objects.requireNonNullElse(ItemStackFactory.build(applyEvent.getStack()), event.getStack()));
                }
            });
            this.onPostGenerateItem(event);
        }
        catch (Throwable t) {
            Logger.trace("{}", t.getMessage());
        }
    }

    public abstract void onPostGenerateItem(ItemRenderEvent var1);

    public abstract void onPreGenerateItem(ItemRenderEvent var1);

    public abstract Map.Entry<Boolean, Boolean> handlePurchase(Player var1, AtomicReference<ItemStack> var2, AtomicReference<sba.sl.i.ItemStack> var3, PlayerItemInfo var4, org.screamingsandals.bedwars.api.game.ItemSpawnerType var5, AtomicReference<String[]> var6);

    @NotNull
    public abstract InventorySetBuilder getInventorySetBuilder();

    public AbstractStoreInventory(@NotNull String shopPaths) {
        if (shopPaths == null) {
            throw new NullPointerException("shopPaths is marked non-null but is null");
        }
        this.shopPaths = shopPaths;
    }
}

