/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.inventories;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.StoreType;
import io.github.pronze.sba.game.tasks.CustomTrap;
import io.github.pronze.sba.game.tasks.CustomTrapTask;
import io.github.pronze.sba.inventories.AbstractStoreInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.ItemSpawner;
import org.screamingsandals.bedwars.api.game.ItemSpawnerType;
import org.screamingsandals.bedwars.game.GameStore;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.si.SimpleInventoriesCore;
import sba.si.builder.InventorySetBuilder;
import sba.si.events.ItemRenderEvent;
import sba.si.inventory.Include;
import sba.si.inventory.InventorySet;
import sba.si.inventory.PlayerItemInfo;
import sba.si.inventory.Property;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.i.meta.EnchantmentType;
import sba.sl.pa.Player;
import sba.sl.pa.Players;
import sba.sl.pu.ServiceManager;
import sba.sl.spectator.Component;
import sba.sl.u.ConfigurateUtils;
import sba.sl.u.Controllable;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;

@Service
@ServiceDependencies(dependsOn={SimpleInventoriesCore.class, SBAConfig.class})
public class SBAStoreInventoryV2
extends AbstractStoreInventory {
    public static List<Integer> sharpnessPrices = new ArrayList<Integer>();
    public static List<Integer> protectionPrices = new ArrayList<Integer>();
    public static List<Integer> efficiencyPrices = new ArrayList<Integer>();
    public static List<Integer> knockbackPrices = new ArrayList<Integer>();
    public static Map<String, List<Integer>> otherPrices = new HashMap<String, List<Integer>>();

    public static SBAStoreInventoryV2 getInstance() {
        return ServiceManager.get(SBAStoreInventoryV2.class);
    }

    public SBAStoreInventoryV2(Controllable controllable) {
        super("");
        controllable.postEnable(this::loadPrices);
    }

    private void loadPrices() {
        SBAConfig.getInstance().node("upgrades", "prices").childrenMap().forEach((key, val) -> {
            String castedKey = ((String)key).toLowerCase();
            int value = val.getInt(4);
            if (castedKey.startsWith("sharpness")) {
                sharpnessPrices.add(value);
            } else if (castedKey.startsWith("prot")) {
                protectionPrices.add(value);
            } else if (castedKey.startsWith("efficiency")) {
                efficiencyPrices.add(value);
            } else if (castedKey.startsWith("knockback")) {
                knockbackPrices.add(value);
            } else {
                if (otherPrices.get(castedKey) == null) {
                    otherPrices.put(castedKey, new ArrayList());
                }
                otherPrices.get(castedKey).add(value);
            }
        });
        if (sharpnessPrices.isEmpty()) {
            sharpnessPrices.add(4);
        }
        if (protectionPrices.isEmpty()) {
            protectionPrices.add(4);
        }
        if (efficiencyPrices.isEmpty()) {
            efficiencyPrices.add(4);
        }
        if (knockbackPrices.isEmpty()) {
            knockbackPrices.add(4);
        }
        Logger.trace("Protection prices: {}", protectionPrices.stream().map(String::valueOf).collect(Collectors.toList()));
        Logger.trace("Efficiency prices: {}", efficiencyPrices.stream().map(String::valueOf).collect(Collectors.toList()));
        Logger.trace("Sharpness prices: {}", sharpnessPrices.stream().map(String::valueOf).collect(Collectors.toList()));
        Logger.trace("knockback prices: {}", sharpnessPrices.stream().map(String::valueOf).collect(Collectors.toList()));
    }

    private void loadDefault(InventorySet inventorySet) {
        inventorySet.getMainSubInventory().dropContents();
        inventorySet.getMainSubInventory().getWaitingQueue().add(Include.of(Path.of(SBAStoreInventoryV2.class.getResource("/shop.yml").toURI())));
        inventorySet.getMainSubInventory().process();
    }

    @Override
    public void onPostGenerateItem(ItemRenderEvent event) {
        event.setStack(ShopUtil.applyTeamUpgradeEnchantsToItem(event.getStack(), event, StoreType.UPGRADES));
    }

    @Override
    public void onPreGenerateItem(ItemRenderEvent event) {
    }

    @Override
    public Map.Entry<Boolean, Boolean> handlePurchase(org.bukkit.entity.Player player, AtomicReference<ItemStack> newItem, AtomicReference<sba.sl.i.ItemStack> materialItem, PlayerItemInfo itemInfo, ItemSpawnerType type, AtomicReference<String[]> messageOnFail) {
        boolean shouldSellStack = true;
        Game game = Main.getInstance().getGameOfPlayer(player);
        IGameStorage gameStorage = ArenaManager.getInstance().get(game.getName()).orElseThrow().getStorage();
        RunningTeam team = game.getTeamOfPlayer(player);
        Player wrappedPlayer = Players.wrapPlayer(player);
        if (itemInfo.getProperties().size() == 0) {
            String typeName;
            String afterUnderscore = typeName.substring((typeName = newItem.get().getType().name()).contains("_") ? typeName.indexOf("_") + 1 : 0);
            ShopUtil.applyTeamEnchants(player, newItem.get());
            switch (afterUnderscore.toLowerCase()) {
                case "sword": {
                    if (!SBAConfig.getInstance().node("replace-sword-on-upgrade").getBoolean(true)) break;
                    Arrays.stream((ItemStack[])player.getInventory().getContents().clone()).filter(Objects::nonNull).filter(itemStack -> itemStack.getType().name().endsWith("SWORD")).filter(itemStack -> !itemStack.isSimilar((ItemStack)newItem.get())).forEach(sword -> player.getInventory().removeItem(new ItemStack[]{sword}));
                    break;
                }
                case "boots": 
                case "chestplate": 
                case "helmet": 
                case "leggings": {
                    return Map.entry(ShopUtil.buyArmor(player, newItem.get().getType(), gameStorage, game), false);
                }
            }
            return Map.entry(true, true);
        }
        block35: for (Property property : itemInfo.getProperties()) {
            if (!property.hasName()) continue;
            String propertyName = property.getPropertyName().toLowerCase();
            Map<?, ?> converted = ConfigurateUtils.raw(property.getPropertyData());
            if (!(converted instanceof Map)) {
                converted = ShopUtil.nullValuesAllowingMap("value", converted);
            }
            Map propertyData = converted;
            propertyData.putIfAbsent("name", propertyName);
            boolean isAdd = false;
            double levelToAdd = 0.0;
            if (property.getPropertyData() != null && property.getPropertyData().childrenMap() != null) {
                isAdd = property.getPropertyData().childrenMap().containsKey("add-levels");
            }
            if (isAdd) {
                levelToAdd = property.getPropertyData().childrenMap().get("add-levels").getDouble(1.0);
            }
            int levelToAddInt = (int)levelToAdd;
            switch (propertyName) {
                case "trap": {
                    if (!property.getPropertyData().hasChild("identifier") && property.getPropertyData().hasChild("data")) {
                        return Map.entry(true, true);
                    }
                    String trap_identifier = property.getPropertyData().childrenMap().get("identifier").getString();
                    if (gameStorage.areTrapEnabled(team, trap_identifier)) {
                        messageOnFail.set(MessageKeys.WAIT_FOR_TRAP);
                        shouldSellStack = false;
                        break;
                    }
                    Component blindnessTrapTitle = LanguageService.getInstance().get(MessageKeys.CUSTOM_TRAP_PURCHASED_TITLE).replace("%trap%", trap_identifier).toComponent();
                    CustomTrap trap = new CustomTrap();
                    trap.setIdentifier(trap_identifier);
                    trap.setTarget(property.getPropertyData().childrenMap().get("target").getString("enemy"));
                    trap.setEffects(new ArrayList<PotionEffect>());
                    property.getPropertyData().childrenMap().get("effects").childrenList().forEach(effectItem -> {
                        try {
                            String effectType = effectItem.childrenMap().get("type").getString();
                            sba.sl.i.meta.PotionEffectType slibEffect = sba.sl.i.meta.PotionEffectType.ofNullable(effectType);
                            PotionEffectType type_ = slibEffect != null ? slibEffect.as(PotionEffectType.class) : PotionEffectType.getByName((String)effectType);
                            if (type_ == null) {
                                Logger.error("{} is not a recognized Potion effect", effectType);
                                return;
                            }
                            PotionEffect pe = new PotionEffect(type_, effectItem.childrenMap().get("duration").getInt(), effectItem.childrenMap().get("level").getInt());
                            trap.getEffects().add(pe);
                        }
                        catch (Throwable t) {
                            Logger.error("Cannot parse potion effect, verify your custom trap configuration", new Object[0]);
                        }
                    });
                    CustomTrapTask.registerTrap(trap);
                    gameStorage.setPurchasedTrap(team, true, trap_identifier);
                    if (SBAConfig.getInstance().trapTitleEnabled()) {
                        team.getConnectedPlayers().forEach(pl -> SBAUtil.sendTitle(Players.wrapPlayer(pl), blindnessTrapTitle, Component.empty(), 20, 40, 20));
                    }
                    if (!SBAConfig.getInstance().trapMessageEnabled()) continue block35;
                    team.getConnectedPlayers().forEach(pl -> Players.wrapPlayer(pl).sendMessage(blindnessTrapTitle));
                    break;
                }
                case "sharpness": {
                    if (isAdd) {
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            LanguageService.getInstance().get(MessageKeys.UGPRADE_TEAM_SHARPNESS).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.increaseTeamEnchant(teamPlayer, item, Enchantment.DAMAGE_ALL, levelToAddInt));
                        });
                        break;
                    }
                    Integer teamSharpnessLevel = gameStorage.getSharpnessLevel(team).orElseThrow();
                    int maxSharpnessLevel = SBAConfig.getInstance().node("upgrades", "limit", "Sharpness").getInt(1);
                    maxSharpnessLevel = Math.min(maxSharpnessLevel, sharpnessPrices.size());
                    if (teamSharpnessLevel >= maxSharpnessLevel) {
                        messageOnFail.set(MessageKeys.GREATEST_ENCHANTMENT);
                        shouldSellStack = false;
                        break;
                    }
                    Integer ePrice = sharpnessPrices.get(teamSharpnessLevel);
                    teamSharpnessLevel = teamSharpnessLevel + 1;
                    materialItem.set(ItemStackFactory.build(type.getStack(ePrice.intValue())));
                    if (player.getInventory().containsAtLeast(materialItem.get().as(ItemStack.class), ePrice.intValue())) {
                        gameStorage.setSharpnessLevel(team, teamSharpnessLevel);
                        Integer finalTeamSharpnessLevel = teamSharpnessLevel;
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            LanguageService.getInstance().get(MessageKeys.UGPRADE_TEAM_SHARPNESS).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.applyTeamEnchants(teamPlayer, item));
                        });
                        break;
                    }
                    shouldSellStack = false;
                    break;
                }
                case "knockback": {
                    if (isAdd) {
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_KNOCKBACK).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.increaseTeamEnchant(teamPlayer, item, Enchantment.KNOCKBACK, levelToAddInt));
                        });
                        break;
                    }
                    Integer teamKnockbackLevel = gameStorage.getSharpnessLevel(team).orElseThrow();
                    int maxKnockbackLevel = SBAConfig.getInstance().node("upgrades", "limit", "Knockback").getInt(1);
                    if (teamKnockbackLevel >= maxKnockbackLevel) {
                        shouldSellStack = false;
                        messageOnFail.set(MessageKeys.GREATEST_ENCHANTMENT);
                        break;
                    }
                    Integer ePrice = knockbackPrices.get(teamKnockbackLevel);
                    teamKnockbackLevel = teamKnockbackLevel + 1;
                    materialItem.set(ItemStackFactory.build(type.getStack(ePrice.intValue())));
                    if (player.getInventory().containsAtLeast(materialItem.get().as(ItemStack.class), ePrice.intValue())) {
                        gameStorage.setSharpnessLevel(team, teamKnockbackLevel);
                        Integer finalTeamSharpnessLevel = teamKnockbackLevel;
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_KNOCKBACK).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.applyTeamEnchants(teamPlayer, item));
                        });
                        break;
                    }
                    shouldSellStack = false;
                    break;
                }
                case "efficiency": {
                    if (isAdd) {
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_EFFICIENCY).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                            Logger.trace("efficiency level add", new Object[0]);
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.increaseTeamEnchant(teamPlayer, item, Enchantment.DIG_SPEED, levelToAddInt));
                        });
                        break;
                    }
                    Integer efficiencyLevel = gameStorage.getEfficiencyLevel(team).orElseThrow();
                    int maxEfficiencyLevel = SBAConfig.getInstance().node("upgrades", "limit", "Efficiency").getInt(2);
                    maxEfficiencyLevel = Math.min(maxEfficiencyLevel, efficiencyPrices.size());
                    if (efficiencyLevel >= maxEfficiencyLevel) {
                        shouldSellStack = false;
                        messageOnFail.set(MessageKeys.GREATEST_ENCHANTMENT);
                        break;
                    }
                    Integer ePrice = efficiencyPrices.get(efficiencyLevel);
                    efficiencyLevel = efficiencyLevel + 1;
                    materialItem.set(ItemStackFactory.build(type.getStack(ePrice.intValue())));
                    if (player.getInventory().containsAtLeast(materialItem.get().as(ItemStack.class), ePrice.intValue())) {
                        gameStorage.setEfficiencyLevel(team, efficiencyLevel);
                        Logger.trace("efficiency {}", efficiencyLevel);
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_EFFICIENCY).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.applyTeamEnchants(teamPlayer, item));
                        });
                        break;
                    }
                    shouldSellStack = false;
                    break;
                }
                case "blindtrap": {
                    if (gameStorage.areBlindTrapEnabled(team)) {
                        shouldSellStack = false;
                        messageOnFail.set(MessageKeys.WAIT_FOR_TRAP);
                        break;
                    }
                    Component blindnessTrapTitle = LanguageService.getInstance().get(MessageKeys.BLINDNESS_TRAP_PURCHASED_TITLE).toComponent();
                    gameStorage.setPurchasedBlindTrap(team, true);
                    if (SBAConfig.getInstance().trapTitleEnabled()) {
                        team.getConnectedPlayers().forEach(pl -> SBAUtil.sendTitle(Players.wrapPlayer(pl), blindnessTrapTitle, Component.empty(), 20, 40, 20));
                    }
                    if (!SBAConfig.getInstance().trapMessageEnabled()) continue block35;
                    team.getConnectedPlayers().forEach(pl -> Players.wrapPlayer(pl).sendMessage(blindnessTrapTitle));
                    break;
                }
                case "minertrap": {
                    if (gameStorage.areMinerTrapEnabled(team)) {
                        shouldSellStack = false;
                        messageOnFail.set(MessageKeys.WAIT_FOR_TRAP);
                        break;
                    }
                    Component minerTrapTitle = LanguageService.getInstance().get(MessageKeys.MINER_TRAP_PURCHASED_TITLE).toComponent();
                    gameStorage.setPurchasedMinerTrap(team, true);
                    if (SBAConfig.getInstance().trapTitleEnabled()) {
                        team.getConnectedPlayers().forEach(pl -> SBAUtil.sendTitle(Players.wrapPlayer(pl), minerTrapTitle, Component.empty(), 20, 40, 20));
                    }
                    if (!SBAConfig.getInstance().trapMessageEnabled()) continue block35;
                    team.getConnectedPlayers().forEach(pl -> Players.wrapPlayer(pl).sendMessage(minerTrapTitle));
                    break;
                }
                case "healpool": {
                    shouldSellStack = false;
                    messageOnFail.set(null);
                    if (gameStorage.arePoolEnabled(team)) {
                        messageOnFail.set(MessageKeys.WAIT_FOR_TRAP);
                        break;
                    }
                    Component purchaseHealPoolMessage = LanguageService.getInstance().get(MessageKeys.PURCHASED_HEAL_POOL_MESSAGE).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).toComponent();
                    gameStorage.setPurchasedPool(team, true);
                    shouldSellStack = true;
                    team.getConnectedPlayers().forEach(pl -> Players.wrapPlayer(pl).sendMessage(purchaseHealPoolMessage));
                    break;
                }
                case "forge": {
                    Map<Object, ? extends ConfigurationNode> map = property.getPropertyData().childrenMap();
                    if (map == null) continue block35;
                    double addLevels = 0.2;
                    double maxLevel = 0.0;
                    List<Object> types = List.of();
                    if (map.containsKey("type")) {
                        try {
                            types = map.get("type").getList(String.class, List.of());
                        }
                        catch (SerializationException e) {
                            e.printStackTrace();
                        }
                    }
                    if (map.containsKey("add-levels")) {
                        addLevels = map.get("add-levels").getDouble(0.2);
                    }
                    if (map.containsKey("max-level")) {
                        maxLevel = map.get("max-level").getDouble(0.0);
                    }
                    boolean sendToAll = true;
                    if (map.containsKey("notify-team")) {
                        sendToAll = map.get("notify-team").getBoolean(true);
                    }
                    Logger.trace("Forge upgrade {}/{}::{}", addLevels, maxLevel, types);
                    ArrayList<ItemSpawner> spawnersToUpgrade = new ArrayList<ItemSpawner>();
                    for (ItemSpawner spawner : game.getItemSpawners()) {
                        String material;
                        if (spawner.getItemSpawnerType() == null || !types.contains(material = spawner.getItemSpawnerType().getName().toLowerCase()) || spawner.getTeam() == null || !spawner.getTeam().getName().equals(team.getName()) || !(spawner.getCurrentLevel() < maxLevel)) continue;
                        spawnersToUpgrade.add(spawner);
                    }
                    double maxLevelF = maxLevel;
                    if (spawnersToUpgrade.isEmpty()) {
                        types.forEach(spawnerType -> {
                            double newLevel;
                            double closestDistance = Double.MAX_VALUE;
                            ItemSpawner closestSpawner = null;
                            for (ItemSpawner spawner : game.getItemSpawners()) {
                                double distance;
                                if (spawner.getItemSpawnerType() == null || !spawner.getItemSpawnerType().getName().toLowerCase().equals(spawnerType) || !((distance = team.getTeamSpawn().distance(spawner.getLocation())) < closestDistance)) continue;
                                closestDistance = distance;
                                closestSpawner = spawner;
                            }
                            if (closestSpawner != null && (newLevel = closestSpawner.getCurrentLevel()) < maxLevelF) {
                                spawnersToUpgrade.add(closestSpawner);
                            }
                        });
                    }
                    for (ItemSpawner spawner : spawnersToUpgrade) {
                        double newLevel = spawner.getCurrentLevel() + addLevels;
                        if (newLevel > maxLevel && maxLevel > 0.0) {
                            newLevel = maxLevel;
                        }
                        spawner.setCurrentLevel(newLevel);
                    }
                    if (!spawnersToUpgrade.isEmpty()) continue block35;
                    messageOnFail.set(MessageKeys.GREATEST_SPAWNER);
                    shouldSellStack = false;
                    break;
                }
                case "protection": {
                    if (isAdd) {
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_PROTECTION).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.increaseTeamEnchant(teamPlayer, item, Enchantment.PROTECTION_ENVIRONMENTAL, levelToAddInt));
                        });
                        break;
                    }
                    Integer teamProtectionLevel = gameStorage.getProtectionLevel(team).orElseThrow();
                    int maxProtectionLevel = SBAConfig.getInstance().node("upgrades", "limit", "Protection").getInt(4);
                    maxProtectionLevel = Math.min(maxProtectionLevel, protectionPrices.size());
                    if (teamProtectionLevel >= maxProtectionLevel) {
                        shouldSellStack = false;
                        messageOnFail.set(MessageKeys.GREATEST_ENCHANTMENT);
                        break;
                    }
                    Logger.trace("protectionPrices:{}", protectionPrices);
                    Integer ePrice = protectionPrices.get(teamProtectionLevel);
                    Logger.trace("ePrice:{}", ePrice);
                    teamProtectionLevel = teamProtectionLevel + 1;
                    Logger.trace("teamProtectionLevel:{}", teamProtectionLevel);
                    materialItem.set(ItemStackFactory.build(type.getStack(ePrice.intValue())));
                    if (player.getInventory().containsAtLeast(materialItem.get().as(ItemStack.class), ePrice.intValue())) {
                        gameStorage.setProtectionLevel(team, teamProtectionLevel);
                        ShopUtil.addEnchantsToPlayerArmor(player, teamProtectionLevel);
                        Component upgradeMessage = LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_PROTECTION).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).toComponent();
                        team.getConnectedPlayers().forEach(teamPlayer -> {
                            Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.applyTeamEnchants(teamPlayer, item));
                            Players.wrapPlayer(teamPlayer).sendMessage(upgradeMessage);
                        });
                        break;
                    }
                    shouldSellStack = false;
                    break;
                }
                default: {
                    if (Arrays.stream(Enchantment.values()).anyMatch(x -> x.getName().equalsIgnoreCase(propertyName) || EnchantmentType.of(x).location().path().equalsIgnoreCase(propertyName))) {
                        if (isAdd) {
                            team.getConnectedPlayers().forEach(teamPlayer -> {
                                LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_ENCHANT).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                                Optional<Enchantment> ech = Arrays.stream(Enchantment.values()).filter(x -> x.getName().equalsIgnoreCase(propertyName) || EnchantmentType.of(x).location().path().equalsIgnoreCase(propertyName)).findAny();
                                Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.increaseTeamEnchant(teamPlayer, item, (Enchantment)ech.get(), levelToAddInt));
                            });
                            break;
                        }
                        Integer teamOtherLevel = gameStorage.getEnchantLevel(team, propertyName).orElseThrow();
                        int maxOtherLevel = SBAConfig.getInstance().node("upgrades", "limit", propertyName).getInt(1);
                        maxOtherLevel = Math.min(maxOtherLevel, otherPrices.get(propertyName).size());
                        if (teamOtherLevel >= maxOtherLevel) {
                            shouldSellStack = false;
                            messageOnFail.set(MessageKeys.GREATEST_ENCHANTMENT);
                            break;
                        }
                        Integer ePrice = otherPrices.get(propertyName).get(teamOtherLevel);
                        teamOtherLevel = teamOtherLevel + 1;
                        materialItem.set(ItemStackFactory.build(type.getStack(ePrice.intValue())));
                        if (player.getInventory().containsAtLeast(materialItem.get().as(ItemStack.class), ePrice.intValue())) {
                            gameStorage.setEnchantLevel(team, propertyName, teamOtherLevel);
                            team.getConnectedPlayers().forEach(teamPlayer -> {
                                LanguageService.getInstance().get(MessageKeys.UPGRADE_TEAM_ENCHANT).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).send(Players.wrapPlayer(teamPlayer));
                                Arrays.stream(teamPlayer.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.applyTeamEnchants(teamPlayer, item));
                            });
                            break;
                        }
                        shouldSellStack = false;
                        break;
                    }
                    return Map.entry(true, true);
                }
            }
        }
        return Map.entry(shouldSellStack, false);
    }

    @Override
    @NotNull
    public InventorySetBuilder getInventorySetBuilder() {
        return ((InventorySetBuilder)SimpleInventoriesCore.builder().categoryOptions(localOptionsBuilder -> localOptionsBuilder.backItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "shopback"), "BARRIER"), itemBuilder -> itemBuilder.name(LanguageService.getInstance().get(MessageKeys.SHOP_PAGE_BACK).toComponent())).pageBackItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "pageback"), "ARROW"), itemBuilder -> itemBuilder.name(LanguageService.getInstance().get(MessageKeys.SHOP_PAGE_BACK).toComponent())).pageForwardItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "pageforward"), "BARRIER"), itemBuilder -> itemBuilder.name(LanguageService.getInstance().get(MessageKeys.SHOP_PAGE_FORWARD).toComponent())).cosmeticItem(SBAConfig.getInstance().readDefinedItem(SBAConfig.getInstance().node("shop", "shopcosmetic"), "GRAY_STAINED_GLASS_PANE")).rows(SBAConfig.getInstance().node("shop", "rows").getInt(6)).renderActualRows(SBAConfig.getInstance().node("shop", "render-actual-rows").getInt(6)).renderOffset(SBAConfig.getInstance().node("shop", "render-offset").getInt(0)).renderHeaderStart(SBAConfig.getInstance().node("shop", "render-header-start").getInt(9)).renderFooterStart(SBAConfig.getInstance().node("shop", "render-footer-start").getInt(600)).itemsOnRow(SBAConfig.getInstance().node("shop", "items-on-row").getInt(9)).showPageNumber(SBAConfig.getInstance().node("shop", "show-page-numbers").getBoolean(false)).inventoryType(SBAConfig.getInstance().node("shop", "inventory-type").getString("CHEST")).prefix(LanguageService.getInstance().get(MessageKeys.SHOP_NAME).toComponent()))).allowAccessToConsole(Main.getConfigurator().config.getBoolean("shop.allow-execution-of-console-commands", true)).variableToProperty("upgrade", "upgrade").variableToProperty("generate-lore", "generateLore").variableToProperty("generated-lore-text", "generatedLoreText").variableToProperty("currency-changer", "currencyChanger");
    }

    @EventHandler
    public void onBedWarsOpenShop(BedwarsOpenShopEvent event) {
        event.setResult(BedwarsOpenShopEvent.Result.DISALLOW_UNKNOWN);
        if (!Main.getInstance().isPlayerPlayingAnyGame(event.getPlayer())) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(Players.wrapPlayer(event.getPlayer()));
            return;
        }
        if (Main.getInstance().getGameOfPlayer(event.getPlayer()).getTeamOfPlayer(event.getPlayer()) == null) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(Players.wrapPlayer(event.getPlayer()));
            return;
        }
        this.openForPlayer(Players.wrapPlayer(event.getPlayer()).as(SBAPlayerWrapper.class), (GameStore)event.getStore());
    }
}

