/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.lang.Message;
import io.github.pronze.sba.lib.lang.LanguageService;
import java.util.List;
import java.util.Random;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.events.BedwarsBedDestroyedMessageSendEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerDeathMessageSendEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.TeamColor;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class BedwarsCustomMessageModifierListener
implements Listener {
    private static final Random RANDOM = new Random();

    @OnPostEnable
    public void onPostEnable() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBedwarsPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game == null) {
            return;
        }
        RunningTeam playerTeam = game.getTeamOfPlayer(player);
        if (playerTeam != null && !playerTeam.isTargetBlockExists() && playerTeam.getConnectedPlayers().size() == 1 && playerTeam.getConnectedPlayers().contains(player)) {
            String teamColorStr = TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)playerTeam.getColor()).chatColor.toString();
            game.getConnectedPlayers().forEach(gPlayer -> LanguageService.getInstance().get(MessageKeys.TEAM_ELIMINATED_MESSAGE).replace("%team%", teamColorStr + playerTeam.getName()).send(Players.wrapPlayer(gPlayer)));
        }
    }

    @EventHandler
    public void onBedWarsBedDestroyedMessageSendEvent(BedwarsBedDestroyedMessageSendEvent event) {
        event.setCancelled(true);
        String teamColorStr = TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)event.getDestroyedTeam().getColor()).chatColor.toString();
        String destroyerTeamColorStr = event.getDestroyer() != null ? TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)event.getGame().getTeamOfPlayer((Player)event.getDestroyer()).getColor()).chatColor.toString() : "";
        String destroyerName = event.getDestroyer() != null ? event.getDestroyer().getDisplayName() : "--";
        List<Component> messages = LanguageService.getInstance().get(MessageKeys.BED_DESTROYED_MESSAGES).replace("%team%", teamColorStr + event.getDestroyedTeam().getName()).replace("%destroyer%", destroyerTeamColorStr + destroyerName).toComponentList();
        Component randomlyChosen = messages.get(RANDOM.nextInt(messages.size()));
        event.getVictim().sendMessage(" ");
        Players.wrapPlayer(event.getVictim()).sendMessage(randomlyChosen);
        event.getVictim().sendMessage(" ");
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onBedWarsPlayerDeathEvent(BedwarsPlayerDeathMessageSendEvent event) {
        Player victim = event.getVictim();
        RunningTeam victimTeam = event.getGame().getTeamOfPlayer(victim);
        String victimTeamColorStr = TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)victimTeam.getColor()).chatColor.toString();
        Message messages = LanguageService.getInstance().get(MessageKeys.DEATH_MESSAGES_PVP_REGULAR).replace("%player%", victimTeamColorStr + event.getVictim().getDisplayName() + String.valueOf(ChatColor.RESET));
        Player killer = victim.getKiller();
        if (killer != null) {
            RunningTeam killerTeam = event.getGame().getTeamOfPlayer(killer);
            String killerTeamColorStr = TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)killerTeam.getColor()).chatColor.toString();
            messages.replace("%killer%", killerTeamColorStr + killer.getDisplayName() + String.valueOf(ChatColor.RESET));
            List<String> list = messages.toStringList();
            event.setMessage(list.get(RANDOM.nextInt(list.size())));
            EntityDamageEvent lastDamageCause = victim.getLastDamageCause();
            if (lastDamageCause != null && lastDamageCause.getCause() == EntityDamageEvent.DamageCause.VOID) {
                Message message = LanguageService.getInstance().get(MessageKeys.DEATH_MESSAGES_VOID_KILL).replace("%player%", victimTeamColorStr + victim.getDisplayName() + String.valueOf(ChatColor.RESET)).replace("%killer%", killerTeamColorStr + killer.getDisplayName() + String.valueOf(ChatColor.RESET));
                event.setMessage(message.toString());
            }
        } else {
            Message message = LanguageService.getInstance().get(MessageKeys.DEATH_MESSAGES_GENERIC).replace("%player%", victimTeamColorStr + victim.getDisplayName() + String.valueOf(ChatColor.RESET));
            event.setMessage(message.toString());
            EntityDamageEvent lastDamageCause = victim.getLastDamageCause();
            if (lastDamageCause != null && lastDamageCause.getCause() == EntityDamageEvent.DamageCause.VOID) {
                message = LanguageService.getInstance().get(MessageKeys.DEATH_MESSAGES_VOID_DEATH).replace("%player%", victimTeamColorStr + victim.getDisplayName() + String.valueOf(ChatColor.RESET));
                event.setMessage(message.toString());
            }
        }
        if (!victimTeam.isTargetBlockExists()) {
            String finalKillPrefix = LanguageService.getInstance().get(MessageKeys.FINAL_KILL_PREFIX).toString();
            event.setMessage(event.getMessage() + " " + finalKillPrefix);
        }
    }
}

