/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.placeholderapi;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.tasks.GeneratorTask;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.Optional;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;

public class SBAExpansion
extends PlaceholderExpansion {
    @NotNull
    public String getIdentifier() {
        return "sba";
    }

    @NotNull
    public String getAuthor() {
        return "pronze";
    }

    public boolean persist() {
        return true;
    }

    @NotNull
    public String getVersion() {
        return SBA.getInstance().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        Logger.trace("Placeholder '" + identifier + "' was requested.", new Object[0]);
        String[] identifiers = identifier.split("_");
        if (identifiers.length <= 1) {
            return null;
        }
        if (identifiers[0].equalsIgnoreCase("player")) {
            if (player == null) {
                return "";
            }
            SBAPlayerWrapper database = PlayerWrapperService.getInstance().get(player).orElseThrow();
            switch (identifiers[1]) {
                case "level": {
                    return Integer.toString(database.getLevel());
                }
                case "xp": {
                    return Integer.toString(database.getXP());
                }
                case "progress": {
                    return Integer.toString(database.getIntegerProgress());
                }
            }
        } else if (identifiers[0].equalsIgnoreCase("game")) {
            if (identifiers.length < 2) {
                return identifier;
            }
            Game game = identifiers.length == 2 ? Main.getInstance().getGameOfPlayer(player) : Main.getInstance().getGameByName(identifiers[1]);
            int offset = identifiers.length == 2 ? 1 : 2;
            Optional<IArena> arena = ArenaManager.getInstance().get(game.getName());
            GeneratorTask generatorTask = arena.isPresent() ? arena.get().getTask(GeneratorTask.class).orElseThrow() : null;
            switch (identifiers[offset]) {
                case "status": {
                    return game.getStatus().toString();
                }
                case "tier": {
                    if (generatorTask != null) {
                        return generatorTask.getNextTierName().replace("-", " ");
                    }
                    return "N/A";
                }
                case "tiertime": {
                    if (generatorTask != null) {
                        return generatorTask.getTimeLeftForNextEvent();
                    }
                    return "N/A";
                }
                case "teams": {
                    return Integer.toString(game.countRunningTeams());
                }
                case "players": {
                    return Integer.toString(game.countConnectedPlayers());
                }
                case "time": {
                    return Integer.toString(game.getArenaTime().time);
                }
                case "gametime": {
                    return Integer.toString(game.getGameTime());
                }
                case "minplayers": {
                    return Integer.toString(game.getMinPlayers());
                }
                case "maxplayers": {
                    return Integer.toString(game.getMaxPlayers());
                }
            }
        } else if (identifiers[0].equalsIgnoreCase("team")) {
            Game game = Main.getInstance().getGameOfPlayer(player);
            Optional<IGameStorage> gameStorage = ArenaManager.getInstance().getGameStorage(game.getName());
            RunningTeam team = game.getTeamOfPlayer(player);
            if (gameStorage == null) {
                return identifier;
            }
            switch (identifiers[1]) {
                case "enchant": {
                    switch (identifiers[2]) {
                        case "protection": {
                            return gameStorage.get().getProtectionLevel(team).orElse(0).toString();
                        }
                        case "efficiency": {
                            return gameStorage.get().getEfficiencyLevel(team).orElse(0).toString();
                        }
                        case "sharpness": {
                            return gameStorage.get().getSharpnessLevel(team).orElse(0).toString();
                        }
                    }
                }
            }
        } else if (identifiers[0].equalsIgnoreCase("version")) {
            return SBA.getInstance().getVersion();
        }
        return super.onPlaceholderRequest(player, identifier);
    }
}

