/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.citizens.BedwarsBlockPlace;
import io.github.pronze.sba.utils.citizens.BridgePillarTrait;
import io.github.pronze.sba.utils.citizens.FakeDeathTrait;
import io.github.pronze.sba.utils.citizens.Strategy;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.trait.SkinTrait;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.api.game.Game;
import sba.sl.npc.NPCManager;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.annotations.methods.OnPreDisable;
import sba.sl.u.reflect.Reflect;

@Service
@ServiceDependencies(dependsOn={NPCManager.class})
public class AIService
implements Listener {
    private static AIService instance;
    NPCRegistryWrapper registry;
    SBAConfig.AIConfig settings;
    Method getPlayerHandle = null;
    Field getPlayerKiller = null;

    public static AIService getInstance() {
        return instance;
    }

    public AIService() {
        instance = this;
    }

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        this.settings = SBAConfig.getInstance().ai();
        if (SBA.getInstance().citizensFix.canEnable() && SBAConfig.getInstance().ai().enabled() && this.registry == null) {
            this.registry = new NPCRegistryWrapper();
            SBA.getInstance().registerListener(this);
        }
    }

    public static void reload() {
        if (AIService.getInstance() != null) {
            instance.onDisable();
            instance.onPostEnabled();
        }
    }

    @OnPreDisable
    public void onDisable() {
        if (this.registry != null) {
            this.registry.getRegistry().deregisterAll();
            this.registry = null;
        }
    }

    public NPC getNPC(Entity e) {
        if (this.registry != null) {
            return this.registry.getRegistry().getNPC(e);
        }
        return null;
    }

    public CompletableFuture<Player> spawnAI(Location loc) {
        return this.spawnAI(loc, Strategy.ANY);
    }

    public CompletableFuture<Player> spawnAI(Location loc, Strategy strategy) {
        CompletableFuture<Player> CompletableFuture2 = new CompletableFuture<Player>();
        if (this.registry != null) {
            AtomicInteger count = new AtomicInteger(1);
            this.registry.getRegistry().forEach(npc -> count.incrementAndGet());
            NPC npc2 = this.registry.getRegistry().createNPC(EntityType.PLAYER, "AI_" + count.get());
            FakeDeathTrait fdt = (FakeDeathTrait)npc2.getOrAddTrait(FakeDeathTrait.class);
            fdt.setStrategy(strategy);
            npc2.spawn(loc);
            npc2.setProtected(false);
            npc2.data().set(NPC.Metadata.REMOVE_FROM_PLAYERLIST, (Object)false);
            npc2.data().set(NPC.Metadata.KEEP_CHUNK_LOADED, (Object)true);
            npc2.data().set(NPC.Metadata.SHOULD_SAVE, (Object)false);
            npc2.data().set(NPC.Metadata.COLLIDABLE, (Object)true);
            npc2.data().set(NPC.Metadata.DISABLE_DEFAULT_STUCK_ACTION, (Object)true);
            npc2.getNavigator().getLocalParameters().attackDelayTicks(1).useNewPathfinder(true);
            npc2.getNavigator().getLocalParameters().distanceMargin(1.0);
            npc2.getNavigator().getLocalParameters().attackRange(1.5);
            npc2.getNavigator().getLocalParameters().avoidWater(true);
            npc2.addTrait((Trait)new BridgePillarTrait());
            npc2.addTrait((Trait)new BedwarsBlockPlace());
            ((SkinTrait)npc2.getOrAddTrait(SkinTrait.class)).setSkinName(this.settings.skin());
            Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
                Player ai = (Player)npc2.getEntity();
                ai.setCanPickupItems(true);
                CompletableFuture2.complete(ai);
            }, this.settings.delay(), TaskerTime.TICKS);
        } else {
            CompletableFuture2.complete(null);
        }
        return CompletableFuture2;
    }

    public boolean isNPC(Player player) {
        return this.registry != null && this.registry.getRegistry().isNPC((Entity)player);
    }

    private Object getHandle(Player player) {
        try {
            Method getHandle = this.getPlayerHandle == null ? (this.getPlayerHandle = player.getClass().getDeclaredMethod("getHandle", new Class[0])) : this.getPlayerHandle;
            return getHandle.invoke((Object)player, getHandle);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onNPCRespawn(PlayerGameModeChangeEvent event) {
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerLeave(BedwarsPlayerLeaveEvent event) {
        Game game = event.getGame();
        Tasker.run(DefaultThreads.GLOBAL_THREAD, () -> {
            boolean allAI = true;
            for (Player p : game.getConnectedPlayers()) {
                if (this.isNPC(p)) continue;
                allAI = false;
                break;
            }
            if (allAI) {
                for (Player p : new ArrayList(game.getConnectedPlayers())) {
                    game.leaveFromGame(p);
                    this.getNPC((Entity)p).destroy();
                }
            }
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDamage(EntityDamageByEntityEvent event) {
        Player entity;
        double damageCount;
        if (event.getEntity().hasMetadata("FakeDeath")) {
            damageCount = event.getFinalDamage();
            entity = (Player)event.getEntity();
            Logger.trace("NPC Damage (By entity)", new Object[0]);
            if (entity.getHealth() < damageCount + 1.0 && event.getDamager() instanceof Player) {
                Player killer = (Player)event.getDamager();
                if (Reflect.hasMethod(entity.getClass(), "setKiller", Player.class)) {
                    entity.setKiller(killer);
                } else {
                    try {
                        Object playerHandle = this.getHandle(entity);
                        Object killerHandle = killer == null ? null : this.getHandle(killer);
                        Field nmsPlayer = this.getPlayerKiller == null ? (this.getPlayerKiller = playerHandle.getClass().getDeclaredField("killer")) : this.getPlayerKiller;
                        nmsPlayer.set(playerHandle, killerHandle);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (event.getDamager().hasMetadata("FakeDeath") && event.getEntity() instanceof LivingEntity) {
            NPC npc;
            damageCount = event.getFinalDamage();
            entity = (LivingEntity)event.getEntity();
            if (entity.getHealth() < damageCount && (npc = this.getNPC(event.getDamager())) != null) {
                npc.getNavigator().cancelNavigation();
            }
        }
    }

    @EventHandler
    public void npcDespawn(NPCDespawnEvent event) {
        NPC npc = event.getNPC();
        if (npc.getEntity() instanceof Player) {
            Player player = ((FakeDeathTrait)npc.getOrAddTrait(FakeDeathTrait.class)).getPlayerObject();
            if (Main.getInstance().isPlayerPlayingAnyGame(player)) {
                if (event.getReason() == DespawnReason.DEATH) {
                    Logger.trace("NPC HAD DEATH, leaving game to prevent issues", new Object[0]);
                    Game g = Main.getInstance().getGameOfPlayer(player);
                    g.leaveFromGame(player);
                    try {
                        npc.destroy();
                    }
                    catch (Exception exception) {}
                } else if (event.getReason() != DespawnReason.REMOVAL && event.getReason() != DespawnReason.PLUGIN) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public void onBedWarsPlayerLeave(BedwarsPlayerLeaveEvent e) {
        if (this.isNPC(e.getPlayer())) {
            this.getNPC((Entity)e.getPlayer()).destroy();
        }
    }

    @EventHandler
    public void onBedWarsPlayerJoin(BedwarsPlayerJoinEvent e) {
        if (this.isNPC(e.getPlayer())) {
            FakeDeathTrait fdt = (FakeDeathTrait)this.getNPC((Entity)e.getPlayer()).getTraitNullable(FakeDeathTrait.class);
            fdt.joinBedwarsGame(e.getGame());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity().hasMetadata("FakeDeath")) {
            double damageCount = event.getFinalDamage();
            Player entity = (Player)event.getEntity();
            Logger.trace("NPC Damage (general)", new Object[0]);
            if (entity.getHealth() < damageCount + 1.0 || event.getCause() == EntityDamageEvent.DamageCause.VOID) {
                Logger.trace("NPC WOULD HAVE DIED", new Object[0]);
                event.setCancelled(true);
                this.die(entity);
            }
        }
    }

    public void die(Player entity) {
        PlayerDeathEvent pde;
        try {
            pde = new PlayerDeathEvent(entity, new ArrayList(), 0, 0, "");
        }
        catch (Throwable ignored) {
            try {
                Class<?> dmgSourceClass = Class.forName("org.bukkit.damage.DamageSource");
                Class<?> dmgType = Class.forName("org.bukkit.damage.DamageType");
                Object damageSource = Reflect.getMethod(Reflect.getMethod(dmgSourceClass, "builder", dmgType).invokeStatic(Reflect.getField(dmgType, "GENERIC_KILL")), "build", new Class[0]).invoke(new Object[0]);
                pde = (PlayerDeathEvent)PlayerDeathEvent.class.getConstructor(Player.class, dmgSourceClass, List.class, Integer.TYPE, Integer.TYPE, String.class).newInstance(entity, damageSource, new ArrayList(), 0, 0, "");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        PlayerRespawnEvent pre = new PlayerRespawnEvent(entity, entity.getLocation(), false);
        entity.setHealth(entity.getMaxHealth());
        NPC npc = this.getNPC((Entity)entity);
        if (npc != null) {
            npc.getNavigator().cancelNavigation();
        }
        this.manualDispatchEvent((Event)pde, (Plugin)Main.getInstance());
        this.manualDispatchEvent((Event)pde, (Plugin)SBA.getPluginInstance());
        this.manualDispatchEvent((Event)pre, (Plugin)Main.getInstance());
        this.manualDispatchEvent((Event)pre, (Plugin)SBA.getPluginInstance());
    }

    private void manualDispatchEvent(Event evt, Plugin p) {
        ArrayList bedwarsHandler = HandlerList.getRegisteredListeners((Plugin)p);
        ArrayList<Method> methods = new ArrayList<Method>();
        for (RegisteredListener handle : bedwarsHandler) {
            Listener listener = handle.getListener();
            if (listener == null) continue;
            Class clazz = listener.getClass();
            for (Method method : clazz.getMethods()) {
                if (methods.contains(method) || method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(evt.getClass())) continue;
                try {
                    methods.add(method);
                    method.invoke((Object)listener, evt);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public NPCRegistryWrapper getRegistry() {
        return this.registry;
    }

    public Method getGetPlayerHandle() {
        return this.getPlayerHandle;
    }

    public Field getGetPlayerKiller() {
        return this.getPlayerKiller;
    }

    public SBAConfig.AIConfig getSettings() {
        return this.settings;
    }

    private class NPCRegistryWrapper {
        NPCRegistry registry = CitizensAPI.createAnonymousNPCRegistry((NPCDataStore)new MemoryNPCDataStore());

        public NPCRegistry getRegistry() {
            return this.registry;
        }
    }
}

