/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.inventories.GamesInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.utils.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import sba.sl.ev.OnEvent;
import sba.sl.npc.NPC;
import sba.sl.npc.event.NPCInteractEvent;
import sba.sl.npc.skin.NPCSkin;
import sba.sl.pa.Player;
import sba.sl.pa.Players;
import sba.sl.pu.ServiceManager;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;
import sba.sl.t.TaskerTime;
import sba.sl.u.InteractType;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.annotations.methods.OnPreDisable;
import sba.sl.u.annotations.parameters.DataFolder;

@Service
@ServiceDependencies(dependsOn={PlayerWrapperService.class})
public class GamesInventoryService
implements Listener {
    private final Map<Integer, Action> entityEditMap = new LinkedHashMap<Integer, Action>();
    private final Map<Integer, Object> entityEditMapArgument = new LinkedHashMap<Integer, Object>();
    private final List<NPCConfig> NPCs = new ArrayList<NPCConfig>();
    private final File dataFolder;

    public static GamesInventoryService getInstance() {
        return ServiceManager.get(GamesInventoryService.class);
    }

    public GamesInventoryService(@DataFolder(value="games-inventory") File dataFolder) {
        this.dataFolder = dataFolder;
    }

    @OnPostEnable
    public void loadGamesInv() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
        File file = new File(this.dataFolder, "npc.yml");
        if (file.exists()) {
            YamlConfiguration config = new YamlConfiguration();
            config.load(file);
            this.NPCs.stream().filter(npcc -> npcc.npc != null).forEach(npcc -> {
                npcc.npc.destroy();
                npcc.npc = null;
            });
            this.NPCs.clear();
            this.checkAndAdd(config, "SOLO", new ArrayList<Location>());
            this.checkAndAdd(config, "DOUBLES", new ArrayList<Location>());
            this.checkAndAdd(config, "TRIPLES", new ArrayList<Location>());
            this.checkAndAdd(config, "SQUADS", new ArrayList<Location>());
            Logger.trace("Loaded old config files into {}", this.NPCs);
            config.getList("npcs").forEach(element -> {
                try {
                    LinkedHashMap npc_config = (LinkedHashMap)element;
                    NPCConfig cfg = new NPCConfig();
                    LinkedHashMap obj = (LinkedHashMap)npc_config.get("skin");
                    if (obj != null) {
                        cfg.skin = (String)obj.get("value");
                        cfg.skin_signature = (String)obj.get("signature");
                    }
                    cfg.location = (Location)npc_config.get("location");
                    cfg.mode = npc_config.get("mode") instanceof Integer ? String.valueOf((Integer)npc_config.get("mode")) : (String)npc_config.get("mode");
                    this.NPCs.add(cfg);
                }
                catch (Exception e) {
                    Logger.error("Could not read {}", e);
                }
            });
            this.NPCs.forEach(npc -> {
                try {
                    Logger.trace("NPC at {} for mode {}", npc.location, npc.mode);
                    NPC n = this.createNpc(npc.mode, npc.location);
                    if (npc.skin != null) {
                        n.skin(new NPCSkin(npc.skin, npc.skin_signature));
                    }
                    npc.npc = n;
                }
                catch (Throwable t) {
                    Logger.error("{}", t);
                }
            });
            this.update();
        }
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> Bukkit.getOnlinePlayers().forEach(player -> this.addViewer((org.bukkit.entity.Player)player)), 1L, TaskerTime.SECONDS);
    }

    private void checkAndAdd(YamlConfiguration config, String mode, List<Location> locations) {
        Object node = config.get(mode.toLowerCase());
        if (node != null) {
            locations.clear();
            locations.addAll((List)node);
            locations.forEach(location -> {
                Logger.trace("Adding NPC at {} for mode {}", location, mode);
                NPCConfig cfg = new NPCConfig();
                cfg.location = location;
                cfg.mode = mode;
                this.NPCs.add(cfg);
            });
            locations.clear();
        }
        Logger.trace("Loaded gamemode {} into {}", mode, locations);
    }

    private NPC createNpc(String mode, Location location) {
        return (NPC)NPC.of(Objects.requireNonNull(sba.sl.w.Location.fromPlatform(location))).lookAtPlayer(true).displayName(LanguageService.getInstance().get(MessageKeys.GAMES_INV_DISPLAY_NAME).replace("%mode%", mode).toComponentList()).show();
    }

    public void addNPC(@NotNull String mode, @NotNull Location location) {
        NPC npc = this.createNpc(mode, location);
        NPCConfig cfg = new NPCConfig();
        cfg.location = location;
        cfg.mode = mode;
        cfg.npc = npc;
        this.NPCs.add(cfg);
        this.update();
    }

    public void removeNPC(Player remover, @NotNull NPC npc) {
        this.NPCs.stream().filter(n -> n.npc == npc).findAny().ifPresent(c -> {
            LanguageService.getInstance().get(MessageKeys.NPC_REMOVED).send(remover);
            c.npc.destroy();
            this.NPCs.remove(c);
            this.update();
        });
    }

    public void update() {
        try {
            File file = new File(this.dataFolder, "npc.yml");
            YamlConfiguration config = new YamlConfiguration();
            if (!file.exists()) {
                file.createNewFile();
            }
            ArrayList npcYaml = new ArrayList();
            this.NPCs.forEach(npc -> {
                YamlConfiguration oneNpc = new YamlConfiguration();
                oneNpc.set("location", (Object)npc.location);
                ConfigurationSection skin = oneNpc.createSection("skin");
                skin.set("value", (Object)npc.skin);
                skin.set("signature", (Object)npc.skin_signature);
                oneNpc.set("mode", (Object)npc.mode);
                npcYaml.add(oneNpc);
            });
            config.set("npcs", npcYaml);
            config.save(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addViewer(@NotNull org.bukkit.entity.Player player) {
        Logger.trace("addViewer", player.getName());
        this.NPCs.forEach(npc -> {
            Logger.trace("npc::addViewer", player.getName());
            if (npc.location.getWorld().equals((Object)player.getWorld()) && npc.npc != null) {
                npc.npc.addViewer(Players.wrapPlayer(player));
            }
        });
    }

    public void removeViewer(@NotNull org.bukkit.entity.Player player) {
        this.NPCs.forEach(npc -> {
            if (npc.npc != null) {
                npc.npc.removeViewer(Players.wrapPlayer(player));
            }
        });
    }

    @OnPreDisable
    public void destroy() {
        Logger.trace("Disabling Games inventory NPCs", new Object[0]);
        this.NPCs.forEach(npc -> {
            npc.npc.destroy();
            npc.npc = null;
        });
        this.update();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        org.bukkit.entity.Player player = e.getPlayer();
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
            if (player.isOnline()) {
                this.addViewer(player);
            }
        }, 1L, TaskerTime.TICKS);
    }

    @EventHandler
    public void onPlayerChangeWorld(PlayerChangedWorldEvent e) {
        org.bukkit.entity.Player player = e.getPlayer();
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
            if (player.isOnline()) {
                this.addViewer(player);
            }
        }, 1L, TaskerTime.TICKS);
    }

    @OnPreDisable
    private void onDisable() {
        this.entityEditMap.clear();
    }

    public void addEditable(Player player, Action mode, Object argument) {
        if (this.entityEditMap.containsKey(player.as(org.bukkit.entity.Player.class).getEntityId())) {
            return;
        }
        this.entityEditMap.put(player.as(org.bukkit.entity.Player.class).getEntityId(), mode);
        this.entityEditMapArgument.put(player.as(org.bukkit.entity.Player.class).getEntityId(), argument);
        Tasker.runDelayed(DefaultThreads.GLOBAL_THREAD, () -> {
            this.entityEditMap.remove(player.as(org.bukkit.entity.Player.class).getEntityId());
            this.entityEditMapArgument.remove(player.as(org.bukkit.entity.Player.class).getEntityId());
        }, 5L, TaskerTime.SECONDS);
    }

    private void setNpcSkin(Player player, NPC visual) {
        String argument = (String)this.entityEditMapArgument.get(player.as(org.bukkit.entity.Player.class).getEntityId());
        NPCSkin.retrieveSkin(argument).whenComplete((skin, exp) -> {
            if (skin != null) {
                this.NPCs.stream().filter(n -> n.npc == visual).findAny().ifPresent(c -> {
                    visual.skin((NPCSkin)skin);
                    c.skin = skin.getValue();
                    c.skin_signature = skin.getSignature();
                    this.update();
                });
            } else {
                Logger.error("Unable to retreive skin of {}: {}", argument, exp);
            }
        });
    }

    @OnEvent
    public void onNPCTouch(final NPCInteractEvent event) {
        if (event.interactType() == InteractType.RIGHT_CLICK && this.entityEditMap.containsKey(event.player().as(org.bukkit.entity.Player.class).getEntityId())) {
            Action a = this.entityEditMap.get(event.player().as(org.bukkit.entity.Player.class).getEntityId());
            if (a == Action.Remove) {
                this.removeNPC(event.player(), (NPC)event.visual());
            } else if (a == Action.Skin) {
                this.setNpcSkin(event.player(), (NPC)event.visual());
            }
            return;
        }
        NPC clicked = (NPC)event.visual();
        this.NPCs.stream().filter(n -> n.npc == clicked).findAny().ifPresent(c -> new BukkitRunnable((NPCConfig)c){
            final /* synthetic */ NPCConfig val$c;
            {
                this.val$c = nPCConfig;
            }

            public void run() {
                GamesInventory.getInstance().openForPlayer(event.player().as(org.bukkit.entity.Player.class), this.val$c.mode);
            }
        }.runTask((Plugin)SBA.getPluginInstance()));
    }

    private class NPCConfig {
        public Location location;
        public String skin;
        public String skin_signature;
        public String mode;
        public NPC npc;

        private NPCConfig() {
        }
    }

    public static enum Action {
        Remove,
        Skin;

    }
}

