/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.utils.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsOpenShopEvent;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStore;
import sba.sl.ev.EventManager;
import sba.sl.npc.NPCManager;
import sba.sl.npc.event.NPCInteractEvent;
import sba.sl.npc.skin.NPCSkin;
import sba.sl.pu.ServiceManager;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
@ServiceDependencies(dependsOn={NPCManager.class})
public class NPCStoreService
implements Listener {
    private NPCSkin shopSkin;
    private NPCSkin upgradeShopSkin;
    private final List<Component> shopText = new ArrayList<Component>();
    private final List<Component> upgradeShopText = new ArrayList<Component>();

    public static NPCStoreService getInstance() {
        return ServiceManager.get(NPCStoreService.class);
    }

    public NPCStoreService() {
        this.shopText.clear();
        this.shopText.addAll(Objects.requireNonNull(SBAConfig.getInstance().node("shop", "normal-shop", "entity-name").getList(String.class)).stream().map(Component::fromLegacy).collect(Collectors.toList()));
        this.upgradeShopText.clear();
        this.upgradeShopText.addAll(Objects.requireNonNull(SBAConfig.getInstance().node("shop", "upgrade-shop", "entity-name").getList(String.class)).stream().map(Component::fromLegacy).collect(Collectors.toList()));
    }

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
        EventManager.getDefaultEventManager().register(NPCInteractEvent.class, this::onNPCTouched);
        if (SBA.getInstance().citizensFix.canEnable()) {
            SBA.getInstance().registerListener(new CitizensListeners());
        }
        this.shopSkin = new NPCSkin(SBAConfig.getInstance().node("shop", "normal-shop", "skin", "value").getString(), SBAConfig.getInstance().node("shop", "normal-shop", "skin", "signature").getString());
        this.upgradeShopSkin = new NPCSkin(SBAConfig.getInstance().node("shop", "upgrade-shop", "skin", "value").getString(), SBAConfig.getInstance().node("shop", "upgrade-shop", "skin", "signature").getString());
    }

    public void onNPCTouched(NPCInteractEvent event) {
        Logger.trace("Clicked NPC with click type: {}", event.interactType().name());
        Player player = event.player().as(Player.class);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            return;
        }
        Logger.trace("Clicked NPC with click type: {}", event.interactType().name());
        Game game = Main.getInstance().getGameOfPlayer(player);
        sba.sl.npc.NPC npc = (sba.sl.npc.NPC)event.visual();
        ArenaManager.getInstance().getArenaMap().values().stream().filter(iArena -> iArena.getStores().values().contains(npc)).forEach(arena -> {
            org.screamingsandals.bedwars.game.GameStore store = null;
            for (Map.Entry<GameStore, sba.sl.npc.NPC> i : arena.getStores().entrySet()) {
                if (!i.getValue().equals(npc)) continue;
                store = (org.screamingsandals.bedwars.game.GameStore)i.getKey();
            }
            final BedwarsOpenShopEvent openShopEvent = new BedwarsOpenShopEvent(game, player, store, null);
            new BukkitRunnable(){

                public void run() {
                    Bukkit.getServer().getPluginManager().callEvent((Event)openShopEvent);
                }
            }.runTask((Plugin)SBA.getPluginInstance());
        });
    }

    public NPCSkin getShopSkin() {
        return this.shopSkin;
    }

    public NPCSkin getUpgradeShopSkin() {
        return this.upgradeShopSkin;
    }

    public List<Component> getShopText() {
        return this.shopText;
    }

    public List<Component> getUpgradeShopText() {
        return this.upgradeShopText;
    }

    private class CitizensListeners
    implements Listener {
        private CitizensListeners() {
        }

        @EventHandler
        public void rclick(NPCRightClickEvent event) {
            NPC npc = event.getNPC();
            Player player = event.getClicker();
            this.npcClick(npc, player);
        }

        private void npcClick(NPC npc, Player player) {
            if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
                return;
            }
            if (!SBAConfig.getInstance().replaceStoreWithCitizen()) {
                return;
            }
            Game game = Main.getInstance().getGameOfPlayer(player);
            ArenaManager.getInstance().getArenaMap().values().stream().filter(iArena -> iArena.getCitizensStores().values().contains(npc)).forEach(arena -> {
                org.screamingsandals.bedwars.game.GameStore store = null;
                for (Map.Entry<GameStore, NPC> i : arena.getCitizensStores().entrySet()) {
                    if (!i.getValue().equals((Object)npc)) continue;
                    store = (org.screamingsandals.bedwars.game.GameStore)i.getKey();
                }
                final BedwarsOpenShopEvent openShopEvent = new BedwarsOpenShopEvent(game, player, store, null);
                new BukkitRunnable(){

                    public void run() {
                        Bukkit.getServer().getPluginManager().callEvent((Event)openShopEvent);
                    }
                }.runTask((Plugin)SBA.getPluginInstance());
            });
        }

        @EventHandler
        public void lclick(NPCLeftClickEvent event) {
            NPC npc = event.getNPC();
            Player player = event.getClicker();
            this.npcClick(npc, player);
        }
    }
}

