/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.specials;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import org.bukkit.Location;
import org.screamingsandals.bedwars.api.Team;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStore;
import org.screamingsandals.bedwars.api.game.ItemSpawner;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
@ServiceDependencies(dependsOn={SBAConfig.class})
public class SpawnerProtection {
    private static SpawnerProtection instance;
    private double spawnerProtectionSize = 0.0;
    private double teamProtectionSize = 0.0;
    private double storeProtectionSize = 0.0;

    @OnPostEnable
    public void registerProtection() {
        if (SBA.isBroken()) {
            return;
        }
        instance = this;
        this.spawnerProtectionSize = SBAConfig.getInstance().getDouble("automatic-protection.spawner-diameter", 0.0);
        this.teamProtectionSize = SBAConfig.getInstance().getDouble("automatic-protection.team-spawn-diameter", 0.0);
        this.storeProtectionSize = SBAConfig.getInstance().getDouble("automatic-protection.store-diameter", 0.0);
    }

    public boolean isProtected(Game g, Location l) {
        return this.isProtectedSpawner(g, l) || this.isProtectedTeam(g, l) || this.isProtectedStore(g, l);
    }

    public boolean isProtectedSpawner(Game g, Location l) {
        if (this.spawnerProtectionSize == 0.0) {
            return false;
        }
        double criteria = this.spawnerProtectionSize / 2.0;
        for (ItemSpawner spawner : g.getItemSpawners()) {
            if (spawner.getItemSpawnerType() == null) continue;
            Location spawnerBlock = spawner.getLocation().getBlock().getLocation();
            double dx = Math.abs(spawnerBlock.getX() - l.getX());
            double dy = Math.abs(spawnerBlock.getY() - l.getY());
            double dz = Math.abs(spawnerBlock.getZ() - l.getZ());
            if (!(dx < criteria) || !(dy < criteria) || !(dz < criteria)) continue;
            return true;
        }
        return false;
    }

    public boolean isProtectedTeam(Game g, Location l) {
        if (this.teamProtectionSize == 0.0) {
            return false;
        }
        double criteria = this.teamProtectionSize / 2.0;
        for (Team team : g.getAvailableTeams()) {
            Location spawnerBlock = team.getTeamSpawn().getBlock().getLocation();
            double dx = Math.abs(spawnerBlock.getX() - l.getX());
            double dy = Math.abs(spawnerBlock.getY() - l.getY());
            double dz = Math.abs(spawnerBlock.getZ() - l.getZ());
            if (!(dx < criteria) || !(dy < criteria) || !(dz < criteria)) continue;
            return true;
        }
        return false;
    }

    public boolean isProtectedStore(Game g, Location l) {
        if (this.storeProtectionSize == 0.0) {
            return false;
        }
        double criteria = this.storeProtectionSize / 2.0;
        for (GameStore store : g.getGameStores()) {
            Location spawnerBlock = store.getStoreLocation().getBlock().getLocation();
            double dx = Math.abs(spawnerBlock.getX() - l.getX());
            double dy = Math.abs(spawnerBlock.getY() - l.getY());
            double dz = Math.abs(spawnerBlock.getZ() - l.getZ());
            if (!(dx < criteria) || !(dy < criteria) || !(dz < criteria)) continue;
            return true;
        }
        return false;
    }

    public static SpawnerProtection getInstance() {
        return instance;
    }
}

