/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.utils.SBAUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;
import org.screamingsandals.bedwars.Main;
import sba.c.serialize.SerializationException;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class FirstStartConfigReplacer {
    private static final Map<Map.Entry<String, String>, String> replacementMap = new HashMap<Map.Entry<String, String>, String>(){
        {
            this.put(Map.entry("items.leavegame", "RED_BED"), "BED");
            this.put(Map.entry("items.shopcosmetic", "GRAY_STAINED_GLASS_PANE"), "STAINED_GLASS_PANE");
        }
    };

    public void enableLegacySupport() {
        if (Main.isLegacy()) {
            AtomicBoolean doneChanges = new AtomicBoolean(false);
            replacementMap.forEach((key, value) -> {
                if (Main.getConfigurator().config.getString((String)key.getKey(), (String)key.getValue()).equalsIgnoreCase((String)key.getValue())) {
                    Main.getConfigurator().config.set((String)key.getKey(), value);
                    doneChanges.set(true);
                }
            });
            if (doneChanges.get()) {
                Bukkit.getLogger().info("[SBA]: Making legacy changes");
                Main.getConfigurator().saveConfig();
                SBAUtil.reloadPlugin((JavaPlugin)Main.getInstance(), null);
            }
        }
    }

    protected void updateConfig(String path, Object value) {
        if (Main.getConfigurator().config.isSet(path)) {
            Main.getConfigurator().config.set(path, null);
        }
        if (value instanceof Map) {
            Main.getConfigurator().config.createSection(path, (Map)value);
        } else {
            Main.getConfigurator().config.set(path, value);
        }
    }

    public void updateBedWarsConfig() {
        this.updateConfig("join-randomly-after-lobby-timeout", true);
        this.updateConfig("spawner-holograms", false);
        this.updateConfig("game-start-items", true);
        this.updateConfig("gived-game-start-items", List.of("WOODEN_SWORD", "LEATHER_HELMET", "LEATHER_CHESTPLATE", "LEATHER_LEGGINGS", "LEATHER_BOOTS"));
        this.updateConfig("destroy-placed-blocks-by-explosion-except", "GLASS");
        this.updateConfig("allowed-commands", List.of("/shout", "/party"));
        this.updateConfig("scoreboard.enable", false);
        this.updateConfig("scoreboard.enabled", false);
        this.updateConfig("lobby-scoreboard.enabled", false);
        this.updateConfig("chat.override", false);
        this.updateConfig("title.enabled", false);
        this.updateConfig("items.leavegame", "RED_BED");
        this.updateConfig("player-drops", false);
        this.updateConfig("compass-enabled", true);
        this.updateConfig("add-wool-to-inventory-on-join", false);
        this.updateConfig("breakable.enabled", true);
        this.updateConfig("breakable.blocks", List.of(!Main.isLegacy() ? "GRASS" : "LONG_GRASS", "SNOW"));
        this.updateConfig("disable-hunger", true);
        this.updateConfig("specials.auto-igniteable-tnt.explosion-time", 3);
        this.updateConfig("resources", Map.of("emerald", Map.of("material", "EMERALD", "color", "GREEN", "name", "Emerald", "interval", 60, "translate", "resource_emerald", "spread", 0.1), "diamond", Map.of("material", "DIAMOND", "color", "BLUE", "name", "Diamond", "interval", 30, "translate", "resource_diamond", "spread", 0.1), "iron", Map.of("material", "IRON_INGOT", "color", "WHITE", "name", "Iron", "interval", 2.5, "translate", "resource_iron", "spread", 0.1), "gold", Map.of("material", "GOLD_INGOT", "color", "GOLD", "name", "Gold", "interval", 8, "translate", "resource_gold", "spread", 0.1)));
        Main.getConfigurator().saveConfig();
    }

    @OnPostEnable
    public void onPostEnable() {
        if (SBA.isBroken()) {
            return;
        }
        this.enableLegacySupport();
        if (SBAConfig.getInstance().node("first_start").getBoolean(false)) {
            Bukkit.getLogger().info("\u00a7aDetected first start");
            this.updateBedWarsConfig();
            SBAConfig.getInstance().upgrade();
            try {
                SBAConfig.getInstance().node("first_start").set(false);
                SBAConfig.getInstance().node("autoset-bw-config").set(false);
                SBAConfig.getInstance().saveConfig();
                SBAConfig.getInstance().forceReload();
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
    }
}

