/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils.citizens;

import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.citizens.FakeDeathTrait;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;

public class AttackOtherGoal
implements FakeDeathTrait.AiGoal {
    private final FakeDeathTrait fakeDeathTrait;
    private Block targetBlock = null;
    private Player targetPlayer = null;

    AttackOtherGoal(FakeDeathTrait fakeDeathTrait) {
        this.fakeDeathTrait = fakeDeathTrait;
    }

    @Override
    public boolean isAvailable() {
        double distance;
        RunningTeam team;
        Game g;
        if (this.fakeDeathTrait.blockPlace() == null) {
            return false;
        }
        if (this.fakeDeathTrait.blockPlace().isInNeedOfBlock()) {
            return false;
        }
        Player aiPlayer = (Player)this.fakeDeathTrait.getNPC().getEntity();
        Location currentLocation = this.fakeDeathTrait.getNPC().getEntity().getLocation();
        if ((this.targetBlock == null || this.fakeDeathTrait.blockPlace().isEmpty(this.targetBlock)) && (g = Main.getInstance().getGameOfPlayer(aiPlayer)) != null && (team = g.getTeamOfPlayer(aiPlayer)) != null) {
            distance = Double.MAX_VALUE;
            for (RunningTeam otherTeam : g.getRunningTeams()) {
                double distanceToCheck;
                if (otherTeam.getName().equals(team.getName()) || !otherTeam.isTargetBlockExists() || !((distanceToCheck = otherTeam.getTargetBlock().distance(currentLocation)) < distance)) continue;
                distance = distanceToCheck;
                this.targetBlock = otherTeam.getTargetBlock().getBlock();
                Logger.trace("AttackOtherGoal::AI will target {} ", this.targetBlock);
            }
        }
        if ((this.targetBlock == null && this.targetPlayer == null || this.targetPlayer != null && (this.targetPlayer.isDead() || this.targetPlayer.getGameMode() == GameMode.SPECTATOR)) && (g = Main.getInstance().getGameOfPlayer(aiPlayer)) != null && (team = g.getTeamOfPlayer(aiPlayer)) != null) {
            distance = Double.MAX_VALUE;
            for (RunningTeam otherTeam : g.getRunningTeams()) {
                if (!otherTeam.isAlive() || otherTeam.getName().equals(team.getName())) continue;
                for (Player p : otherTeam.getConnectedPlayers()) {
                    double distanceToCheck = p.getLocation().distance(currentLocation);
                    if (p.isDead() || p.getGameMode() != GameMode.SURVIVAL || !(distanceToCheck < distance)) continue;
                    distance = distanceToCheck;
                    this.targetPlayer = p;
                    Logger.trace("AttackOtherGoal::AI will target {} ", this.targetPlayer);
                }
            }
        }
        return this.targetBlock != null || this.targetPlayer != null;
    }

    @Override
    public void doGoal() {
        if (this.targetBlock != null) {
            if (this.fakeDeathTrait.blockPlace().isEmpty(this.targetBlock)) {
                this.targetBlock = null;
                return;
            }
            Player aiPlayer = this.fakeDeathTrait.getNpcEntity();
            double distance = this.targetBlock.getLocation().distance(aiPlayer.getLocation());
            if (distance < 3.0) {
                this.fakeDeathTrait.blockPlace().breakBlock(this.fakeDeathTrait.blockPlace().viewedBlock(this.targetBlock));
            } else {
                this.fakeDeathTrait.getNPC().getNavigator().setTarget(this.targetBlock.getLocation());
            }
        } else if (this.targetPlayer != null) {
            this.fakeDeathTrait.getNPC().getNavigator().setTarget((Entity)this.targetPlayer, true);
        }
    }
}

