/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils.citizens;

import io.github.pronze.sba.inventories.SBAStoreInventoryV2;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.citizens.FakeDeathTrait;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;
import org.bukkit.entity.Player;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStore;
import org.screamingsandals.bedwars.game.ItemSpawnerType;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.InventorySet;
import sba.si.inventory.Price;
import sba.si.inventory.SubInventory;
import sba.sl.i.ItemStack;

public class GatherBlocks
implements FakeDeathTrait.AiGoal {
    private final FakeDeathTrait fakeDeathTrait;
    private Trade tr = null;
    private org.screamingsandals.bedwars.game.GameStore gsTarget = null;
    private double distance;

    GatherBlocks(FakeDeathTrait fakeDeathTrait) {
        this.fakeDeathTrait = fakeDeathTrait;
    }

    @Override
    public boolean isAvailable() {
        if (this.fakeDeathTrait.blockPlace() == null) {
            return false;
        }
        if (this.fakeDeathTrait.blockPlace().isInNeedOfBlock()) {
            Player aiPlayer = (Player)this.fakeDeathTrait.getNPC().getEntity();
            Game g = Main.getInstance().getGameOfPlayer(aiPlayer);
            if (this.gsTarget == null) {
                this.distance = Double.MAX_VALUE;
                this.gsTarget = null;
                this.tr = null;
                if (g != null) {
                    for (GameStore storeapi : g.getGameStores()) {
                        org.screamingsandals.bedwars.game.GameStore store = (org.screamingsandals.bedwars.game.GameStore)storeapi;
                        double distanceToShop = store.getStoreLocation().distance(aiPlayer.getLocation());
                        if (!(distanceToShop < this.distance)) continue;
                        this.iterateShop(aiPlayer, store, (p, i) -> {
                            org.bukkit.inventory.ItemStack is;
                            ItemSpawnerType potentialItemSpawnerType = Main.getSpawnerType((String)p.getCurrency());
                            if (potentialItemSpawnerType != null && aiPlayer.getInventory().containsAtLeast(potentialItemSpawnerType.getStack(), p.getAmount()) && (is = i.as(org.bukkit.inventory.ItemStack.class)).getType().isBlock()) {
                                this.tr = new Trade((Price)p, is);
                                this.gsTarget = store;
                                this.distance = distanceToShop;
                                Logger.trace("NPC {} Can afford this trade {} for {}", this.fakeDeathTrait.getNPC().getName(), this.tr.getIs(), this.tr.getP());
                            }
                        });
                    }
                    if (this.tr == null) {
                        Logger.trace("NPC {} Cannot afford the required blocks", this.fakeDeathTrait.getNPC().getName());
                    }
                }
            }
        }
        return this.gsTarget != null;
    }

    @Override
    public void doGoal() {
        Player aiPlayer = (Player)this.fakeDeathTrait.getNPC().getEntity();
        double distanceToShop = this.gsTarget.getStoreLocation().distance(aiPlayer.getLocation());
        if (distanceToShop > 3.0) {
            this.fakeDeathTrait.getNPC().getNavigator().setTarget(this.gsTarget.getStoreLocation());
            Logger.trace("NPC {} moving towards store", this.fakeDeathTrait.getNPC().getName());
        } else {
            ItemSpawnerType potentialItemSpawnerType = Main.getSpawnerType((String)this.tr.getP().getCurrency());
            if (potentialItemSpawnerType != null) {
                org.bukkit.inventory.ItemStack toRemove = potentialItemSpawnerType.getStack(this.tr.getP().getAmount());
                aiPlayer.getInventory().remove(toRemove);
                aiPlayer.getInventory().addItem(new org.bukkit.inventory.ItemStack[]{this.tr.getIs()});
                this.fakeDeathTrait.blockPlace().setInNeedOfBlock(false);
                Logger.trace("NPC {} doing trade {} for {}", this.fakeDeathTrait.getNPC().getName(), this.tr.getIs(), this.tr.getP());
            }
            this.gsTarget = null;
            this.tr = null;
        }
    }

    public void iterateShop(Player aiPlayer, org.screamingsandals.bedwars.game.GameStore gs, BiConsumer<Price, ItemStack> consumer) {
        InventorySet storeInv;
        if (!(gs.getShopFile() != null && StringUtils.containsIgnoreCase((String)gs.getShopFile(), (String)"upgrade") || (storeInv = SBAStoreInventoryV2.getInstance().iterate(gs)) == null)) {
            SubInventory subInventory = storeInv.getMainSubInventory();
            for (GenericItemInfo inventoryParent : subInventory.getContents()) {
                for (Price price : inventoryParent.getPrices()) {
                    ItemStack item = inventoryParent.getItem();
                    consumer.accept(price, item);
                }
            }
        }
    }

    private class Trade {
        private Price p;
        private org.bukkit.inventory.ItemStack is;

        public Trade(Price p, org.bukkit.inventory.ItemStack is) {
            this.p = p;
            this.is = is;
        }

        public Price getP() {
            return this.p;
        }

        public org.bukkit.inventory.ItemStack getIs() {
            return this.is;
        }

        public void setP(Price p) {
            this.p = p;
        }

        public void setIs(org.bukkit.inventory.ItemStack is) {
            this.is = is;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Trade)) {
                return false;
            }
            Trade other = (Trade)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Price this$p = this.getP();
            Price other$p = other.getP();
            if (this$p == null ? other$p != null : !((Object)this$p).equals(other$p)) {
                return false;
            }
            org.bukkit.inventory.ItemStack this$is = this.getIs();
            org.bukkit.inventory.ItemStack other$is = other.getIs();
            return !(this$is == null ? other$is != null : !this$is.equals(other$is));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Trade;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Price $p = this.getP();
            result = result * 59 + ($p == null ? 43 : ((Object)$p).hashCode());
            org.bukkit.inventory.ItemStack $is = this.getIs();
            result = result * 59 + ($is == null ? 43 : $is.hashCode());
            return result;
        }

        public String toString() {
            return "GatherBlocks.Trade(p=" + String.valueOf(this.getP()) + ", is=" + String.valueOf(this.getIs()) + ")";
        }
    }
}

