/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.visuals;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.ConfigBoard;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.implementations.WrapperBoard;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.data.GamePlayerData;
import io.github.pronze.sba.game.Arena;
import io.github.pronze.sba.game.tasks.GeneratorTask;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.manager.ScoreboardManager;
import io.github.pronze.sba.utils.DateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.game.Game;
import org.screamingsandals.bedwars.game.TeamColor;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;
import sba.sl.t.DefaultThreads;
import sba.sl.t.Tasker;

public class GameScoreboardManager
implements ScoreboardManager {
    private final Game game;
    private final Arena arena;
    private final Map<UUID, Scoreboard> scoreboardMap = new HashMap<UUID, Scoreboard>();
    private final List<String> scoreboard_lines = new ArrayList<String>();
    protected BukkitTask updateTask;

    public GameScoreboardManager(Arena arena) {
        this.arena = arena;
        this.game = (Game)Main.getInstance().getGameByName(arena.getGame().getName());
        if (this.game.countAvailableTeams() >= 5) {
            this.scoreboard_lines.addAll(LanguageService.getInstance().get(MessageKeys.SCOREBOARD_LINES_5).toStringList());
        } else {
            this.scoreboard_lines.addAll(LanguageService.getInstance().get(MessageKeys.SCOREBOARD_LINES_DEFAULT).toStringList());
        }
        if (SBAConfig.getInstance().getBoolean("game-scoreboard.enabled", true).booleanValue()) {
            this.game.getConnectedPlayers().forEach(this::createScoreboard);
        }
    }

    public Optional<Scoreboard> getScoreboard(@NotNull UUID playerUUID) {
        return Optional.ofNullable(this.scoreboardMap.get(playerUUID));
    }

    @Override
    public void createScoreboard(@NotNull Player player) {
        Optional<Scoreboard> scoreboardOptional = io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager.getInstance().fromCache(player.getUniqueId());
        scoreboardOptional.ifPresent(Scoreboard::destroy);
        List<String> title = LanguageService.getInstance().get(MessageKeys.ANIMATED_BEDWARS_TITLE).toStringList();
        Scoreboard scoreboard = Scoreboard.builder().animate(true).player(player).displayObjective("bwa-game").updateInterval(10L).animationInterval(2L).animatedTitle(title).updateCallback(board -> {
            board.setLines(this.process(player, board));
            return true;
        }).build();
        WrapperBoard holder = scoreboard.getHolder().of(player);
        if (holder != null) {
            Tasker.run(DefaultThreads.GLOBAL_THREAD, () -> this.game.getRunningTeams().forEach(team -> {
                if (!holder.hasTeamEntry(team.getName())) {
                    holder.addTeam(team.getName(), TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).chatColor);
                }
                Team scoreboardTeam = holder.getTeamOrRegister(team.getName());
                try {
                    scoreboardTeam.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                team.getConnectedPlayers().forEach(teamPlayer -> {
                    if (!scoreboardTeam.hasEntry(teamPlayer.getName())) {
                        scoreboardTeam.addEntry(teamPlayer.getName());
                    }
                });
            }));
        }
        this.scoreboardMap.put(player.getUniqueId(), scoreboard);
    }

    @Override
    public void removeScoreboard(@NotNull Player player) {
        if (this.scoreboardMap.containsKey(player.getUniqueId())) {
            Scoreboard scoreboard = this.scoreboardMap.get(player.getUniqueId());
            if (scoreboard != null) {
                scoreboard.destroy();
            }
            this.scoreboardMap.remove(player.getUniqueId());
        }
    }

    @Override
    public void destroy() {
        this.scoreboardMap.values().forEach(Scoreboard::destroy);
        this.scoreboardMap.clear();
        if (this.updateTask != null && (Bukkit.getScheduler().isCurrentlyRunning(this.updateTask.getTaskId()) || Bukkit.getScheduler().isQueued(this.updateTask.getTaskId()))) {
            this.updateTask.cancel();
        }
    }

    public List<String> process(Player player, Scoreboard board) {
        ConfigBoard holder = board.getHolder();
        ArrayList<String> lines = new ArrayList<String>();
        Optional<GamePlayerData> optionalPlayerData = this.arena.getPlayerData(player.getUniqueId());
        if (optionalPlayerData.isEmpty()) {
            return List.of();
        }
        GamePlayerData playerData = optionalPlayerData.get();
        RunningTeam playerTeam = this.game.getTeamOfPlayer(player);
        PlayerStatistic statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player);
        if (statistic == null) {
            Main.getInstance().getStatisticsManager().loadStatistic(player.getUniqueId());
            statistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player);
            if (statistic == null) {
                return List.of();
            }
        }
        String totalKills = String.valueOf(statistic.getKills());
        String currentKills = String.valueOf(playerData.getKills());
        String finalKills = String.valueOf(playerData.getFinalKills());
        String currentDeaths = String.valueOf(playerData.getDeaths());
        String currentBedDestroys = String.valueOf(playerData.getBedDestroys());
        String teamName = playerTeam == null ? "" : playerTeam.getName();
        String teamStatus = playerTeam != null ? this.getTeamBedStatus(playerTeam) : null;
        this.scoreboard_lines.stream().filter(Objects::nonNull).forEach(line -> {
            if (line.contains("%team_status%")) {
                String finalLine = line;
                this.game.getAvailableTeams().forEach(t -> {
                    String you = "";
                    if (playerTeam != null && playerTeam.getName().equalsIgnoreCase(t.getName())) {
                        you = LanguageService.getInstance().get(MessageKeys.SCOREBOARD_YOU_MESSAGE).toString();
                    }
                    lines.add(finalLine.replace("%team_status%", this.getTeamStatusFormat((org.screamingsandals.bedwars.api.Team)t).replace("%you%", you)));
                });
                return;
            }
            GeneratorTask generatorTask = this.arena.getTask(GeneratorTask.class).orElseThrow();
            line = line.replace("%sba_version%", SBA.getInstance().getVersion()).replace("%team%", teamName).replace("%beds%", currentBedDestroys).replace("%dies%", currentDeaths).replace("%totalkills%", totalKills).replace("%finalkills%", finalKills).replace("%kills%", currentKills).replace("%time%", this.game.getFormattedTimeLeft()).replace("%formattime%", this.game.getFormattedTimeLeft()).replace("%game%", this.game.getName()).replace("%date%", DateUtils.getFormattedDate()).replace("%team_bed_status%", teamStatus == null ? "" : teamStatus).replace("%tier_task%", generatorTask.getNextTierName()).replace("%tier_time%", generatorTask.getTimeLeftForNextEvent()).replace("%tier%", generatorTask.getNextTierName().replace("-", " ") + " in \u00a7a" + generatorTask.getTimeLeftForNextEvent());
            lines.add((String)line);
        });
        return lines;
    }

    private String getTeamBedStatus(RunningTeam team) {
        return team.isDead() ? SBAConfig.getInstance().node("team-status", "target-destroyed").getString("\u00a7c\u2717") : SBAConfig.getInstance().node("team-status", "target-exists").getString("\u00a7a\u2713");
    }

    private String getTeamStatusFormat(RunningTeam team) {
        String alive = SBAConfig.getInstance().teamStatus().alive();
        String destroyed = SBAConfig.getInstance().teamStatus().destroyed();
        String eliminated = SBAConfig.getInstance().teamStatus().eliminated();
        String status = team.isTargetBlockExists() ? alive : (team.getConnectedPlayers().size() > 0 ? destroyed : eliminated);
        String formattedTeam = TeamColor.valueOf((String)team.getColor().name()).chatColor.toString() + team.getName().charAt(0);
        status = status.replace("%bed_status%", this.getTeamBedStatus(team)).replace("%color%", formattedTeam).replace("%team%", String.valueOf(ChatColor.WHITE) + team.getName() + ":");
        int teamSize = team.getConnectedPlayers().size();
        status = status.replace("%players%", ChatColor.GREEN.toString() + teamSize);
        return status;
    }

    private String getTeamStatusFormat(org.screamingsandals.bedwars.api.Team team) {
        return this.game.getRunningTeams().stream().filter(t -> t.getName().equalsIgnoreCase(team.getName())).map(this::getTeamStatusFormat).findAny().orElseGet(() -> {
            String destroyed = SBAConfig.getInstance().node("team-status", "eliminated").getString("%color% %team% \u00a7c\u2718 %you%");
            String formattedTeam = TeamColor.valueOf((String)team.getColor().name()).chatColor.toString() + team.getName().charAt(0);
            return destroyed.replace("%color%", formattedTeam).replace("%team%", String.valueOf(ChatColor.WHITE) + team.getName() + ":");
        });
    }
}

