/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.visuals;

import io.github.pronze.lib.pronzelib.scoreboards.Scoreboard;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerJoinedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.statistics.PlayerStatistic;
import sba.sl.pa.Players;
import sba.sl.pu.ServiceManager;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.annotations.methods.OnPreDisable;

@Service
public class MainLobbyVisualsManager
implements Listener {
    private static final String MAIN_LOBBY_OBJECTIVE = "sbascoreboard";
    private static Location location;
    private final Map<Player, Scoreboard> scoreboardMap = new HashMap<Player, Scoreboard>();
    private boolean enabled;

    public static MainLobbyVisualsManager getInstance() {
        return ServiceManager.get(MainLobbyVisualsManager.class);
    }

    @OnPostEnable
    public void registerListener() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
        this.load();
    }

    public void reload() {
        this.disable();
        this.load();
    }

    public void load() {
        if (!SBAConfig.getInstance().getBoolean("main-lobby.enabled", false).booleanValue()) {
            this.enabled = false;
            return;
        }
        this.enabled = true;
        SBAUtil.readLocationFromConfig("main-lobby").ifPresentOrElse(location -> {
            MainLobbyVisualsManager.location = location;
            Bukkit.getScheduler().runTaskLater((Plugin)SBA.getPluginInstance(), () -> Bukkit.getOnlinePlayers().forEach(this::create), 3L);
        }, () -> {
            this.disable();
            Bukkit.getServer().getLogger().warning("Could not find lobby world!");
        });
    }

    public static boolean isInWorld(Location loc) {
        try {
            return loc.getWorld().equals((Object)location.getWorld());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasMainLobbyObjective(Player player) {
        return player.getScoreboard().getObjective(MAIN_LOBBY_OBJECTIVE) != null;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent e) {
        if (!this.enabled) {
            return;
        }
        if (!SBAConfig.getInstance().node("main-lobby", "custom-chat").getBoolean(true)) {
            return;
        }
        Player player = e.getPlayer();
        SBAPlayerWrapper db = SBA.getInstance().getPlayerWrapperService().get(player).orElseThrow();
        if (SBAConfig.getInstance().node("main-lobby", "enabled").getBoolean(false) && MainLobbyVisualsManager.isInWorld(e.getPlayer().getLocation())) {
            if (Main.isPlayerInGame((Player)player)) {
                return;
            }
            String chatFormat = LanguageService.getInstance().get(MessageKeys.MAIN_LOBBY_CHAT_FORMAT).toString();
            if (chatFormat != null) {
                String format = chatFormat.replace("%level%", String.valueOf(db.getLevel())).replace("%name%", e.getPlayer().getDisplayName() + String.valueOf(ChatColor.RESET)).replace("%message%", e.getMessage()).replace("%color%", ShopUtil.ChatColorChanger(e.getPlayer()));
                if (SBA.getPluginInstance().getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                    format = PlaceholderAPI.setPlaceholders((Player)player, (String)format);
                }
                String msgToSend = format;
                Bukkit.getServer().getOnlinePlayers().forEach(p -> {
                    if (MainLobbyVisualsManager.isInWorld(p.getLocation()) && Main.getInstance().getGameOfPlayer(p) == null) {
                        p.sendMessage(msgToSend);
                    }
                });
                e.setCancelled(true);
            }
        }
    }

    @OnPreDisable
    public void disable() {
        Set.copyOf(this.scoreboardMap.keySet()).forEach(this::remove);
        this.scoreboardMap.clear();
        this.enabled = false;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJoin(PlayerJoinEvent e) {
        if (!this.enabled) {
            return;
        }
        Player player = e.getPlayer();
        Bukkit.getServer().getScheduler().runTaskLater((Plugin)SBA.getPluginInstance(), () -> {
            if (MainLobbyVisualsManager.hasMainLobbyObjective(player)) {
                return;
            }
            if (MainLobbyVisualsManager.isInWorld(player.getLocation()) && !Main.isPlayerInGame((Player)player) && player.isOnline()) {
                this.create(player);
            }
        }, 20L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onWorldChange(PlayerChangedWorldEvent e) {
        if (!this.enabled) {
            return;
        }
        Player player = e.getPlayer();
        if (player.isOnline() && MainLobbyVisualsManager.isInWorld(player.getLocation()) && !this.scoreboardMap.containsKey(player)) {
            this.create(player);
        } else {
            this.remove(player);
        }
    }

    @EventHandler
    public void onPlayerLeave(PlayerQuitEvent e) {
        this.remove(e.getPlayer());
    }

    public void create(Player player) {
        if (!this.enabled) {
            return;
        }
        if (!MainLobbyVisualsManager.isInWorld(player.getLocation())) {
            return;
        }
        SBAPlayerWrapper playerData = SBA.getInstance().getPlayerWrapperService().get(player).orElseThrow();
        if (SBAConfig.getInstance().node("main-lobby", "tablist-modifications").getBoolean()) {
            Component header = LanguageService.getInstance().get(MessageKeys.MAIN_LOBBY_TABLIST_HEADER).replace("%sba_version%", SBA.getInstance().getVersion()).toComponent();
            Component footer = LanguageService.getInstance().get(MessageKeys.MAIN_LOBBY_TABLIST_FOOTER).replace("%sba_version%", SBA.getInstance().getVersion()).toComponent();
            playerData.sendPlayerListHeaderFooter(header, footer);
        }
        String title = LanguageService.getInstance().get(MessageKeys.MAIN_LOBBY_SCOREBOARD_TITLE).toString();
        List<String> lines = LanguageService.getInstance().get(MessageKeys.MAIN_LOBBY_SCOREBOARD_LINES).toStringList();
        Scoreboard scoreboard = Scoreboard.builder().animate(false).player(player).title(title).displayObjective(MAIN_LOBBY_OBJECTIVE).updateInterval(20L).lines(lines).placeholderHook(hook -> {
            String bar = playerData.getCompletedBoxes();
            String progress = playerData.getProgress();
            PlayerStatistic playerStatistic = Main.getPlayerStatisticsManager().getStatistic((OfflinePlayer)player);
            return hook.getLine().replace("%sba_version%", SBA.getInstance().getVersion()).replace("%kills%", String.valueOf(playerStatistic.getKills())).replace("%beddestroys%", String.valueOf(playerStatistic.getDestroyedBeds())).replace("%deaths%", String.valueOf(playerStatistic.getDeaths())).replace("%level%", "\u00a77" + playerData.getLevel() + "\u272b").replace("%progress%", progress).replace("%bar%", bar).replace("%wins%", String.valueOf(playerStatistic.getWins())).replace("%kdr%", String.valueOf(playerStatistic.getKD()));
        }).build();
        this.scoreboardMap.put(player, scoreboard);
    }

    public void remove(Player player) {
        if (player == null) {
            return;
        }
        Scoreboard scoreboard = this.scoreboardMap.get(player);
        if (scoreboard != null) {
            scoreboard.destroy();
            this.scoreboardMap.remove(player);
        }
        if (MainLobbyVisualsManager.hasMainLobbyObjective(player)) {
            player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        }
        if (SBAConfig.getInstance().node("main-lobby", "tablist-modifications").getBoolean()) {
            Players.wrapPlayer(player).sendPlayerListHeaderFooter(Component.empty(), Component.empty());
        }
    }

    @EventHandler
    public void onBedWarsPlayerJoin(BedwarsPlayerJoinedEvent e) {
        Player player = e.getPlayer();
        this.remove(player);
    }

    @EventHandler
    public void onBedWarsPlayerLeaveEvent(BedwarsPlayerLeaveEvent e) {
        Player player = e.getPlayer();
        if (!this.enabled) {
            return;
        }
    }
}

